/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.poppet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.blocks.entity.PoppetShelfBlockEntity;
import net.favouriteless.enchanted.common.items.component.EDataComponents;
import net.favouriteless.enchanted.common.items.component.EntityRefData;
import net.favouriteless.enchanted.common.poppet.PoppetShelfInventory;
import net.favouriteless.enchanted.common.poppet.PoppetUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;

public class PoppetShelfSavedData
extends SavedData {
    private static final String NAME = "enchanted_poppets";
    public final Map<UUID, List<PoppetEntry>> PLAYER_POPPETS = new HashMap<UUID, List<PoppetEntry>>();
    public final Map<String, PoppetShelfInventory> SHELF_STORAGE = new HashMap<String, PoppetShelfInventory>();
    public final ServerLevel level;

    public PoppetShelfSavedData(ServerLevel world) {
        this.level = world;
    }

    public static PoppetShelfSavedData get(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel overworld = level.getServer().overworld();
            return (PoppetShelfSavedData)overworld.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> new PoppetShelfSavedData(overworld), (nbt, reg) -> PoppetShelfSavedData.load(overworld, nbt, reg), null), NAME);
        }
        throw new RuntimeException("Game attempted to load server-side poppet shelf data from a client-side world.");
    }

    public static PoppetShelfSavedData load(ServerLevel level, CompoundTag nbt, HolderLookup.Provider registries) {
        PoppetShelfSavedData data = new PoppetShelfSavedData(level);
        for (String identifier : nbt.getAllKeys()) {
            ServerLevel world = data.getLevelFromShelfIdentifier(identifier);
            BlockPos pos = data.getBlockPosFromShelfIdentifier(identifier);
            PoppetShelfInventory inventory = new PoppetShelfInventory((Level)world, pos);
            inventory.load((CompoundTag)nbt.get(identifier), registries);
            data.SHELF_STORAGE.put(identifier, inventory);
            data.setupPoppetUUIDs(identifier, inventory);
        }
        Enchanted.LOG.info("Loaded poppet shelves successfully");
        return data;
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registries) {
        for (String identifier : this.SHELF_STORAGE.keySet()) {
            CompoundTag tag = new CompoundTag();
            PoppetShelfInventory inventory = this.SHELF_STORAGE.get(identifier);
            inventory.save(tag, registries);
            nbt.put(identifier, (Tag)tag);
        }
        Enchanted.LOG.info("Saved poppet shelves successfully");
        return nbt;
    }

    public void updateShelf(String identifier) {
        BlockPos pos;
        ServerLevel level = this.getLevelFromShelfIdentifier(identifier);
        BlockEntity blockEntity = level.getBlockEntity(pos = this.getBlockPosFromShelfIdentifier(identifier));
        if (blockEntity instanceof PoppetShelfBlockEntity) {
            ((PoppetShelfBlockEntity)blockEntity).updateBlock();
        }
    }

    public void setupPoppetUUIDs(String identifier, PoppetShelfInventory inventory) {
        for (ItemStack item : inventory) {
            this.setupPoppetUUID(identifier, item);
        }
    }

    public void removePoppetUUIDs(String identifier, PoppetShelfInventory inventory) {
        for (ItemStack item : inventory) {
            this.removePoppetUUID(identifier, item);
        }
    }

    public void setupPoppetUUID(String identifier, ItemStack stack) {
        if (PoppetUtils.isBound(stack)) {
            UUID uuid = ((EntityRefData)stack.get(EDataComponents.ENTITY_REF.get())).uuid();
            this.PLAYER_POPPETS.putIfAbsent(uuid, new ArrayList());
            this.PLAYER_POPPETS.get(uuid).add(new PoppetEntry(stack, identifier));
        }
    }

    public void removePoppetUUID(String identifier, ItemStack stack) {
        if (PoppetUtils.isBound(stack)) {
            this.PLAYER_POPPETS.get(((EntityRefData)stack.get(EDataComponents.ENTITY_REF.get())).uuid()).removeIf(entry -> entry.matches(stack, identifier));
        }
    }

    public static String getShelfIdentifier(BlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return String.format("%s+%s+%s+%s", blockEntity.getLevel().dimension().location(), pos.getX(), pos.getY(), pos.getZ());
    }

    public static String getShelfIdentifier(Level level, BlockPos pos) {
        return String.format("%s+%s+%s+%s", level.dimension().location(), pos.getX(), pos.getY(), pos.getZ());
    }

    public ServerLevel getLevelFromShelfIdentifier(String shelfIdentifier) {
        String levelString = shelfIdentifier.substring(0, shelfIdentifier.indexOf("+"));
        return this.level.getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)levelString)));
    }

    public BlockPos getBlockPosFromShelfIdentifier(String shelfIdentifier) {
        String[] strings = shelfIdentifier.substring(shelfIdentifier.indexOf("+") + 1).split("\\+");
        return new BlockPos(Integer.parseInt(strings[0]), Integer.parseInt(strings[1]), Integer.parseInt(strings[2]));
    }

    public record PoppetEntry(ItemStack item, String shelfIdentifier) {
        public boolean matches(ItemStack stack, String shelfIdentifier) {
            return stack.equals(this.item) && shelfIdentifier.equals(this.shelfIdentifier);
        }
    }
}

