/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.poppet;

import java.util.ArrayList;
import java.util.List;
import net.favouriteless.enchanted.common.blocks.entity.PoppetShelfBlockEntity;
import net.favouriteless.enchanted.common.poppet.PoppetShelfInventory;
import net.favouriteless.enchanted.common.poppet.PoppetShelfSavedData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;

public class PoppetShelfManager {
    public static PoppetShelfInventory getInventoryFor(PoppetShelfBlockEntity shelf) {
        if (shelf.getLevel() instanceof ServerLevel) {
            PoppetShelfSavedData data = PoppetShelfSavedData.get(shelf.getLevel());
            PoppetShelfManager.resolveAbsentShelf(data, shelf);
            return data.SHELF_STORAGE.get(PoppetShelfSavedData.getShelfIdentifier(shelf));
        }
        return null;
    }

    public static void removeShelf(PoppetShelfBlockEntity shelf) {
        if (shelf.getLevel() instanceof ServerLevel) {
            PoppetShelfSavedData data = PoppetShelfSavedData.get(shelf.getLevel());
            String identifier = PoppetShelfSavedData.getShelfIdentifier(shelf);
            data.removePoppetUUIDs(identifier, data.SHELF_STORAGE.get(identifier));
            data.SHELF_STORAGE.remove(identifier);
        }
    }

    public static void resolveAbsentShelf(PoppetShelfSavedData data, PoppetShelfBlockEntity shelf) {
        String identifier = PoppetShelfSavedData.getShelfIdentifier(shelf);
        if (!data.SHELF_STORAGE.containsKey(identifier)) {
            data.SHELF_STORAGE.put(identifier, new PoppetShelfInventory(shelf.getLevel(), shelf.getBlockPos()));
        }
    }

    public static List<PoppetShelfSavedData.PoppetEntry> getEntriesFor(Player player) {
        if (!player.level().isClientSide) {
            List<PoppetShelfSavedData.PoppetEntry> list;
            PoppetShelfSavedData data = PoppetShelfSavedData.get(player.level());
            if (data.PLAYER_POPPETS.containsKey(player.getUUID()) && (list = data.PLAYER_POPPETS.get(player.getUUID())) != null) {
                return list;
            }
        }
        return new ArrayList<PoppetShelfSavedData.PoppetEntry>();
    }
}

