/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.poppet;

import java.util.AbstractList;
import java.util.List;
import net.favouriteless.enchanted.common.poppet.PoppetShelfSavedData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PoppetShelfInventory
extends AbstractList<ItemStack>
implements Container {
    private final Level level;
    private final BlockPos pos;
    private final String identifier;
    public NonNullList<ItemStack> inventoryContents = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);

    public PoppetShelfInventory(Level level, BlockPos pos) {
        this.level = level;
        this.pos = pos;
        this.identifier = PoppetShelfSavedData.getShelfIdentifier(level, pos);
    }

    public int getContainerSize() {
        return this.size();
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty();
    }

    public ItemStack getItem(int index) {
        return this.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem((List)this, (int)index, (int)count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem((List)this, (int)index);
    }

    public void setItem(int index, ItemStack itemStack) {
        this.set(index, itemStack);
    }

    public void setChanged() {
        if (!this.level.isClientSide) {
            PoppetShelfSavedData.get(this.level).setDirty();
        }
    }

    public boolean stillValid(Player player) {
        return false;
    }

    public void clearContent() {
        this.inventoryContents.clear();
    }

    public void save(CompoundTag tag, HolderLookup.Provider registries) {
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventoryContents, (HolderLookup.Provider)registries);
    }

    public void load(CompoundTag tag, HolderLookup.Provider registries) {
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventoryContents, (HolderLookup.Provider)registries);
    }

    public Level getLevel() {
        return this.level;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public ItemStack get(int index) {
        return (ItemStack)this.inventoryContents.get(index);
    }

    @Override
    public ItemStack set(int index, ItemStack value) {
        if (!this.level.isClientSide) {
            if (this.get(index).isEmpty()) {
                this.get(index).setCount(1);
            }
            PoppetShelfSavedData data = PoppetShelfSavedData.get(this.level);
            data.removePoppetUUID(this.identifier, this.get(index));
            data.setupPoppetUUID(this.identifier, value);
        }
        this.setChanged();
        return (ItemStack)this.inventoryContents.set(index, (Object)value);
    }

    @Override
    public int size() {
        return this.inventoryContents.size();
    }
}

