/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.poppet;

import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.common.init.ETags;
import net.favouriteless.enchanted.common.items.poppets.DeathPoppetItem;
import net.favouriteless.enchanted.common.poppet.PoppetShelfManager;
import net.favouriteless.enchanted.common.poppet.PoppetUseResult;
import net.favouriteless.enchanted.common.poppet.PoppetUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PoppetEvents {
    public static boolean onLivingEntityHurt(LivingEntity entity, float amount, DamageSource source) {
        Player player;
        if (entity instanceof Player && amount >= (player = (Player)entity).getHealth()) {
            PoppetUseResult result = PoppetUtils.tryUseItems(PoppetUtils.getPoppetQueue(player, item -> {
                DeathPoppetItem poppet;
                return item instanceof DeathPoppetItem && (poppet = (DeathPoppetItem)((Object)item)).protectsAgainst(source);
            }), player);
            if (result.type() != PoppetUseResult.ResultType.PASS) {
                return result.isSuccess();
            }
            return PoppetUtils.tryUseEntries(PoppetUtils.getPoppetQueue(PoppetShelfManager.getEntriesFor(player), entry -> {
                DeathPoppetItem poppet;
                Item patt0$temp = entry.item().getItem();
                return patt0$temp instanceof DeathPoppetItem && (poppet = (DeathPoppetItem)patt0$temp).protectsAgainst(source);
            }), player).isSuccess();
        }
        return false;
    }

    public static void onPlayerItemBreak(Player player, ItemStack item, InteractionHand hand) {
        if (item.is(ETags.Items.TOOL_POPPET_WHITELIST) && !item.is(ETags.Items.TOOL_POPPET_BLACKLIST)) {
            PoppetUseResult result = PoppetUtils.tryUseItems(PoppetUtils.getPoppetQueue(player, EItems::isToolPoppet), player, item);
            if (result.type() == PoppetUseResult.ResultType.FAIL) {
                return;
            }
            boolean cancelled = result.isSuccess();
            if (!cancelled) {
                cancelled = PoppetUtils.tryUseEntries(PoppetUtils.getPoppetQueue(PoppetShelfManager.getEntriesFor(player), entry -> EItems.isToolPoppet(entry.item().getItem())), player, item).isSuccess();
            }
            if (cancelled) {
                player.setItemInHand(hand, item);
            }
        }
    }

    public static boolean onArmourHurt(LivingEntity entity, EquipmentSlot slot, ItemStack item, float damage) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if ((float)(item.getMaxDamage() - item.getDamageValue()) <= damage && !item.is(ETags.Items.ARMOR_POPPET_BLACKLIST)) {
                PoppetUseResult result = PoppetUtils.tryUseItems(PoppetUtils.getPoppetQueue(player, EItems::isArmourPoppet), player, item);
                if (result.type() == PoppetUseResult.ResultType.FAIL) {
                    return false;
                }
                boolean cancelled = result.isSuccess();
                if (!cancelled) {
                    cancelled = PoppetUtils.tryUseEntries(PoppetUtils.getPoppetQueue(PoppetShelfManager.getEntriesFor(player), entry -> EItems.isArmourPoppet(entry.item().getItem())), player, item).isSuccess();
                }
                if (cancelled) {
                    player.setItemSlot(slot, item);
                    return true;
                }
            }
        }
        return false;
    }
}

