/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.network.client;

import net.favouriteless.enchanted.client.particles.types.TwoColourOptions;
import net.favouriteless.enchanted.client.render.poppet.PoppetAnimationManager;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.init.EParticleTypes;
import net.favouriteless.enchanted.common.items.poppets.PoppetItem;
import net.favouriteless.enchanted.common.poppet.PoppetColour;
import net.favouriteless.enchanted.common.poppet.PoppetUseResult;
import net.favouriteless.enchanted.platform.PacketContext;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class PoppetAnimationPayload
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<PoppetAnimationPayload> TYPE = new CustomPacketPayload.Type(Enchanted.id("poppet_animation"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PoppetAnimationPayload> STREAM_CODEC = StreamCodec.composite(PoppetUseResult.ResultType.STREAM_CODEC, p -> p.result, (StreamCodec)ItemStack.STREAM_CODEC, p -> p.item, (StreamCodec)ByteBufCodecs.INT, p -> p.entityId, PoppetAnimationPayload::new);
    private final PoppetUseResult.ResultType result;
    private final ItemStack item;
    private final int entityId;

    public PoppetAnimationPayload(PoppetUseResult.ResultType result, ItemStack itemStack, int entityId) {
        this.result = result;
        this.item = itemStack;
        this.entityId = entityId;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(PoppetAnimationPayload payload, PacketContext context) {
        Minecraft mc = Minecraft.getInstance();
        Entity entity = mc.level.getEntity(payload.entityId);
        if (entity != null && payload.item.getItem() instanceof PoppetItem) {
            PoppetColour colour = ((PoppetItem)payload.item.getItem()).colour;
            mc.particleEngine.createTrackingEmitter(entity, (ParticleOptions)new TwoColourOptions(EParticleTypes.POPPET.get(), FastColor.ARGB32.color((int)colour.rPrimary, (int)colour.gPrimary, (int)colour.gSecondary), FastColor.ARGB32.color((int)colour.rSecondary, (int)colour.gSecondary, (int)colour.bSecondary)), 40);
            if (entity == mc.player) {
                PoppetAnimationManager.startAnimation(payload.result, payload.item);
            }
        }
    }
}

