/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.mutandis;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.favouriteless.enchanted.common.Enchanted;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;

public class MutagenSavedData
extends SavedData {
    public static final String NAME = Enchanted.savedDataName("mutagens");
    private final Map<ChunkPos, Object2BooleanMap<BlockPos>> mutatingBlocks = new HashMap<ChunkPos, Object2BooleanMap<BlockPos>>();

    public static MutagenSavedData get(ServerLevel level) {
        return (MutagenSavedData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(MutagenSavedData::new, MutagenSavedData::load, null), NAME);
    }

    public void add(BlockPos pos, boolean extremis) {
        this.mutatingBlocks.computeIfAbsent(new ChunkPos(pos), k -> new Object2BooleanOpenHashMap()).put((Object)pos, extremis);
        this.setDirty();
    }

    public void remove(BlockPos pos) {
        Object2BooleanMap<BlockPos> map = this.mutatingBlocks.get(new ChunkPos(pos));
        if (map != null) {
            map.removeBoolean((Object)pos);
            this.setDirty();
        }
    }

    public boolean contains(BlockPos pos) {
        Object2BooleanMap<BlockPos> map = this.mutatingBlocks.get(new ChunkPos(pos));
        return map != null && map.containsKey((Object)pos);
    }

    public boolean isExtremis(BlockPos pos) {
        Object2BooleanMap<BlockPos> map = this.mutatingBlocks.get(new ChunkPos(pos));
        return map != null && map.getBoolean((Object)pos);
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registries) {
        ListTag chunkList = new ListTag();
        for (Map.Entry<ChunkPos, Object2BooleanMap<BlockPos>> entry : this.mutatingBlocks.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            ListTag list = new ListTag();
            for (Object2BooleanMap.Entry e : entry.getValue().object2BooleanEntrySet()) {
                CompoundTag tag = new CompoundTag();
                tag.putLong("pos", ((BlockPos)e.getKey()).asLong());
                tag.putBoolean("extremis", e.getBooleanValue());
                list.add((Object)tag);
            }
            CompoundTag chunk = new CompoundTag();
            chunk.putLong("chunk", entry.getKey().toLong());
            chunk.put("positions", (Tag)list);
            chunkList.add((Object)chunk);
        }
        nbt.put("chunks", (Tag)chunkList);
        return nbt;
    }

    public static MutagenSavedData load(CompoundTag nbt, HolderLookup.Provider provider) {
        MutagenSavedData data = new MutagenSavedData();
        ListTag chunkList = nbt.getList("chunks", 10);
        for (Tag t : chunkList) {
            CompoundTag chunk = (CompoundTag)t;
            Object2BooleanOpenHashMap posMap = new Object2BooleanOpenHashMap();
            for (Tag p : chunk.getList("positions", 4)) {
                CompoundTag pos = (CompoundTag)p;
                posMap.put((Object)BlockPos.of((long)pos.getLong("pos")), pos.getBoolean("extremis"));
            }
            ChunkPos pos = new ChunkPos(nbt.getLong("chunk"));
            data.mutatingBlocks.put(pos, (Object2BooleanMap<BlockPos>)posMap);
        }
        return data;
    }
}

