/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.mutandis;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.favouriteless.enchanted.api.MutagenManager;
import net.favouriteless.enchanted.common.init.EData;
import net.favouriteless.enchanted.common.mutandis.MutagenInfo;
import net.favouriteless.enchanted.common.mutandis.MutagenSavedData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MutagenManagerImpl
implements MutagenManager {
    public static final MutagenManagerImpl INSTANCE = new MutagenManagerImpl();

    private MutagenManagerImpl() {
    }

    @Override
    public boolean tryStartMutating(ServerLevel level, BlockPos pos, boolean extremis) {
        if (!this.isMutating(level, pos) && this.canMutate(level, level.getBlockState(pos).getBlock())) {
            MutagenSavedData.get(level).add(pos, extremis);
            return true;
        }
        return false;
    }

    @Override
    public boolean isMutating(ServerLevel level, BlockPos pos) {
        return MutagenSavedData.get(level).contains(pos);
    }

    @Override
    public boolean canMutate(ServerLevel level, Block block) {
        return level.registryAccess().registryOrThrow(EData.MUTAGEN_REGISTRY).containsKey(BuiltInRegistries.BLOCK.getKey((Object)block));
    }

    @Override
    public Map<Block, List<MutagenInfo.MutagenSet>> getMutagensFor(Level level, Block result) {
        HashMap<Block, List<MutagenInfo.MutagenSet>> out = new HashMap<Block, List<MutagenInfo.MutagenSet>>();
        for (Map.Entry entry : level.registryAccess().registryOrThrow(EData.MUTAGEN_REGISTRY).entrySet()) {
            Block mutee = (Block)BuiltInRegistries.BLOCK.get(((ResourceKey)entry.getKey()).location());
            for (MutagenInfo.MutagenSet set : ((MutagenInfo)entry.getValue()).sets()) {
                if (set.result() != result) continue;
                out.computeIfAbsent(mutee, l -> new ArrayList()).add(set);
            }
        }
        return out;
    }

    public boolean randomTick(ServerLevel level, BlockPos pos) {
        if (!this.canMutate(level, level.getBlockState(pos).getBlock())) {
            return false;
        }
        if (!this.isMutating(level, pos)) {
            return false;
        }
        return this.tryMutate(level, pos);
    }

    private boolean tryMutate(ServerLevel level, BlockPos pos) {
        Block block;
        Registry registry = level.registryAccess().registryOrThrow(EData.MUTAGEN_REGISTRY);
        MutagenInfo info = (MutagenInfo)registry.get(BuiltInRegistries.BLOCK.getKey((Object)(block = level.getBlockState(pos).getBlock())));
        if (info == null) {
            return false;
        }
        Object2IntMap<MutagenInfo.MutagenSet> counts = this.getValidMutagenSets(level, pos, info);
        MutagenInfo.MutagenSet set = this.getRandomWeighted(this.getWeightedBlocks(counts));
        if (set == null) {
            return false;
        }
        double chance = (double)Math.min(counts.getInt((Object)set), 40) / 280.0 * 1.5;
        if (Math.random() >= chance) {
            return false;
        }
        this.mutate(level, pos, set.result());
        return true;
    }

    private void mutate(ServerLevel level, BlockPos pos, Block newBlock) {
        BlockState state = level.getBlockState(pos);
        BlockState newState = newBlock.defaultBlockState();
        for (Property property : state.getProperties()) {
            if (!newState.hasProperty(property)) continue;
            newState = this.copyProperty(property, state, newState);
        }
        level.setBlockAndUpdate(pos, newState);
        level.playSound(null, pos, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.MASTER);
        level.sendParticles((ParticleOptions)ParticleTypes.WITCH, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 25, 0.5, 0.5, 0.5, 0.0);
    }

    private <T extends Comparable<T>> BlockState copyProperty(Property<T> property, BlockState old, BlockState state) {
        return (BlockState)state.setValue(property, old.getValue(property));
    }

    private Object2IntMap<MutagenInfo.MutagenSet> getValidMutagenSets(ServerLevel level, BlockPos pos, MutagenInfo info) {
        Object2IntOpenHashMap out = new Object2IntOpenHashMap(info.sets().size());
        boolean extremis = MutagenSavedData.get(level).isExtremis(pos);
        for (BlockPos p : BlockPos.betweenClosed((int)(pos.getX() - 2), (int)(pos.getY() - 2), (int)(pos.getZ() - 2), (int)(pos.getX() + 2), (int)(pos.getY() + 2), (int)(pos.getZ() + 2))) {
            Block block = level.getBlockState(p).getBlock();
            for (MutagenInfo.MutagenSet set : info.sets()) {
                if (!set.mutagens().contains(block) || set.extremis() && !extremis) continue;
                out.put((Object)set, out.getOrDefault((Object)set, 0) + 1);
            }
        }
        return out;
    }

    private Object2DoubleMap<MutagenInfo.MutagenSet> getWeightedBlocks(Object2IntMap<MutagenInfo.MutagenSet> sets) {
        Object2DoubleOpenHashMap out = new Object2DoubleOpenHashMap(sets.size());
        int total = 0;
        for (MutagenInfo.MutagenSet set : sets.keySet()) {
            total += set.weight();
        }
        sets.forEach((arg_0, arg_1) -> MutagenManagerImpl.lambda$getWeightedBlocks$1((Object2DoubleMap)out, arg_0, arg_1));
        for (MutagenInfo.MutagenSet set : sets.keySet()) {
            out.put((Object)set, (double)(sets.getInt((Object)set) * set.weight()) / (double)total);
        }
        return out;
    }

    private MutagenInfo.MutagenSet getRandomWeighted(Object2DoubleMap<MutagenInfo.MutagenSet> weights) {
        ArrayList<Pair> cumulativeWeights = new ArrayList<Pair>(weights.size());
        double sum = 0.0;
        for (MutagenInfo.MutagenSet set : weights.keySet()) {
            cumulativeWeights.add(Pair.of((Object)set, (Object)(sum += weights.getDouble((Object)set))));
        }
        double rand = Math.random();
        for (Pair pair : cumulativeWeights) {
            if (!((Double)pair.getSecond() / sum > rand)) continue;
            return (MutagenInfo.MutagenSet)pair.getFirst();
        }
        return null;
    }

    private static /* synthetic */ void lambda$getWeightedBlocks$1(Object2DoubleMap out, MutagenInfo.MutagenSet set, Integer i) {
        out.put((Object)set, 0.0);
    }
}

