/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.multiblock.altar;

import net.favouriteless.enchanted.common.blocks.altar.AltarBlock;
import net.favouriteless.enchanted.common.blocks.entity.AltarBlockEntity;
import net.favouriteless.enchanted.common.init.EBlocks;
import net.favouriteless.enchanted.common.multiblock.IMultiBlockType;
import net.favouriteless.enchanted.common.multiblock.altar.AltarPartIndex;
import net.favouriteless.enchanted.common.stateobservers.AltarStateObserver;
import net.favouriteless.stateobserver.api.StateObserver;
import net.favouriteless.stateobserver.api.StateObserverManager;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AltarMultiBlock
implements IMultiBlockType {
    public static AltarMultiBlock INSTANCE = new AltarMultiBlock();

    @Override
    public boolean isValidFormedBlock(Level level, BlockPos pos, int dx, int dy, int dz) {
        BlockPos p = pos.offset(dx, dy, dz);
        BlockState state = level.getBlockState(p);
        if (AltarMultiBlock.isFormedAltar(state)) {
            AltarPartIndex index = (AltarPartIndex)((Object)state.getValue(AltarBlock.FORMED));
            return index == AltarPartIndex.getIndex(dx, dz);
        }
        return false;
    }

    @Override
    public boolean isValidUnformedBlock(Level level, BlockPos pos, int dx, int dy, int dz) {
        BlockPos p = pos.offset(dx, dy, dz);
        BlockState state = level.getBlockState(p);
        return AltarMultiBlock.isUnformedAltar(state);
    }

    @Override
    public void create(Level world, BlockPos pos) {
        if (this.isValidUnformedMultiBlockX(world, pos)) {
            for (int dx = 0; dx < 3; ++dx) {
                for (int dz = 0; dz < 2; ++dz) {
                    if (!this.isValidUnformedBlock(world, pos, dx, 0, dz)) continue;
                    this.formBlock(world, pos.offset(dx, 0, dz), dx, 0, dz, true);
                }
            }
        } else {
            for (int dx = 0; dx < 2; ++dx) {
                for (int dz = 0; dz < 3; ++dz) {
                    if (!this.isValidUnformedBlock(world, pos, dx, 0, dz)) continue;
                    this.formBlock(world, pos.offset(dx, 0, dz), dx, 0, dz, false);
                }
            }
        }
    }

    @Override
    public BlockPos getBottomLowerLeft(Level level, BlockPos pos, BlockState state) {
        if (AltarMultiBlock.isFormedAltar(state)) {
            AltarPartIndex index = (AltarPartIndex)((Object)state.getValue(AltarBlock.FORMED));
            return pos.offset(-index.getDx(), -index.getDy(), -index.getDz());
        }
        return null;
    }

    @Override
    public void unformBlock(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.is((Block)EBlocks.ALTAR.get())) {
            if (state.getValue(AltarBlock.FORMED) == AltarPartIndex.P000) {
                AltarStateObserver observer = (AltarStateObserver)StateObserverManager.get().getObserver(level, pos, AltarStateObserver.class);
                if (observer != null) {
                    StateObserverManager.get().removeObserver((StateObserver)observer);
                }
                if (level.getBlockEntity(pos) instanceof AltarBlockEntity) {
                    level.removeBlockEntity(pos);
                }
            }
            level.setBlockAndUpdate(pos, EBlocks.ALTAR.get().defaultBlockState());
        }
    }

    @Override
    public void formBlock(Level level, BlockPos pos, int dx, int dy, int dz) {
        this.formBlock(level, pos, dx, dy, dz, false);
    }

    public void formBlock(Level world, BlockPos pos, int dx, int dy, int dz, boolean facingX) {
        world.setBlockAndUpdate(pos, (BlockState)((BlockState)EBlocks.ALTAR.get().defaultBlockState().setValue(AltarBlock.FORMED, (Comparable)((Object)AltarPartIndex.getIndex(dx, dz)))).setValue((Property)AltarBlock.FACING_X, (Comparable)Boolean.valueOf(facingX)));
    }

    @Override
    public boolean isValidUnformedMultiBlock(Level world, BlockPos pos) {
        return this.isValidUnformedMultiBlockX(world, pos) || this.isValidUnformedMultiBlockZ(world, pos);
    }

    private boolean isValidUnformedMultiBlockX(Level world, BlockPos pos) {
        if (!this.isValidUnformedBlock(world, pos, 0, 0, 0)) {
            return false;
        }
        int validCount = 0;
        for (int dx = 0; dx < 3; ++dx) {
            for (int dz = 0; dz < 2; ++dz) {
                if (!this.isValidUnformedBlock(world, pos, dx, 0, dz)) continue;
                ++validCount;
            }
        }
        return validCount == 6;
    }

    private boolean isValidUnformedMultiBlockZ(Level world, BlockPos pos) {
        if (!this.isValidUnformedBlock(world, pos, 0, 0, 0)) {
            return false;
        }
        int validCount = 0;
        for (int dx = 0; dx < 2; ++dx) {
            for (int dz = 0; dz < 3; ++dz) {
                if (!this.isValidUnformedBlock(world, pos, dx, 0, dz)) continue;
                ++validCount;
            }
        }
        return validCount == 6;
    }

    @Override
    public boolean isValidFormedMultiBlock(Level level, BlockPos pos) {
        int dz;
        int dx;
        if (!this.isValidFormedBlock(level, pos, 0, 0, 0)) {
            return false;
        }
        int validCount = 0;
        for (dx = 0; dx < 3; ++dx) {
            for (dz = 0; dz < 2; ++dz) {
                if (!this.isValidFormedBlock(level, pos, dx, 0, dz)) continue;
                ++validCount;
            }
        }
        if (validCount == 6) {
            return true;
        }
        validCount = 0;
        for (dx = 0; dx < 2; ++dx) {
            for (dz = 0; dz < 3; ++dz) {
                if (!this.isValidFormedBlock(level, pos, dx, 0, dz)) continue;
                ++validCount;
            }
        }
        return validCount == 6;
    }

    private static boolean isUnformedAltar(BlockState state) {
        return state.is((Block)EBlocks.ALTAR.get()) && state.getValue(AltarBlock.FORMED) == AltarPartIndex.UNFORMED;
    }

    private static boolean isFormedAltar(BlockState state) {
        return state.is((Block)EBlocks.ALTAR.get()) && state.getValue(AltarBlock.FORMED) != AltarPartIndex.UNFORMED;
    }

    @Override
    public int getWidth() {
        return 3;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    @Override
    public int getDepth() {
        return 3;
    }
}

