/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.menus;

import net.favouriteless.enchanted.common.blocks.entity.WitchOvenBlockEntity;
import net.favouriteless.enchanted.common.init.EBlocks;
import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.common.init.EMenuTypes;
import net.favouriteless.enchanted.common.menus.MenuBase;
import net.favouriteless.enchanted.common.menus.slots.FuelSlot;
import net.favouriteless.enchanted.common.menus.slots.JarInputSlot;
import net.favouriteless.enchanted.common.menus.slots.NonJarInputSlot;
import net.favouriteless.enchanted.common.menus.slots.OutputSlot;
import net.favouriteless.enchanted.common.util.ItemUtils;
import net.favouriteless.enchanted.common.util.MenuUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class WitchOvenMenu
extends MenuBase<WitchOvenBlockEntity> {
    private final ContainerData data;

    public WitchOvenMenu(int id, Inventory playerInventory, WitchOvenBlockEntity be, ContainerData data) {
        super(EMenuTypes.WITCH_OVEN.get(), id, be, (Block)EBlocks.WITCH_OVEN.get());
        this.data = data;
        this.addSlot(new NonJarInputSlot(be, 0, 53, 17));
        this.addSlot(new JarInputSlot(be, 1, 53, 53));
        this.addSlot(new FuelSlot(be, 2, 80, 53));
        this.addSlot(new OutputSlot(be, 3, 107, 17));
        this.addSlot(new OutputSlot(be, 4, 107, 53));
        this.addInventorySlots(playerInventory, 8, 84);
        this.addDataSlots(data);
    }

    public WitchOvenMenu(int id, Inventory playerInventory, BlockPos pos) {
        this(id, playerInventory, MenuUtils.getBlockEntity(playerInventory, pos, WitchOvenBlockEntity.class), (ContainerData)new SimpleContainerData(4));
    }

    public int getBurnProgress() {
        return this.data.get(0);
    }

    public int getBurnDuration() {
        return this.data.get(1);
    }

    public int getCookProgress() {
        return this.data.get(2);
    }

    public int getCookDuration() {
        return this.data.get(3);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotItem = slot.getItem();
            ItemStack originalItem = slotItem.copy();
            if (index < 5 ? !this.moveItemStackTo(slotItem, 5, 41, true) : (this.hasRecipe(slotItem) ? !this.moveItemStackTo(slotItem, 0, 1, false) : (ItemUtils.isFuel(slotItem) ? !this.moveItemStackTo(slotItem, 2, 3, false) : (originalItem.getItem() == EItems.CLAY_JAR.get() ? !this.moveItemStackTo(slotItem, 1, 2, false) : (index < 32 ? !this.moveItemStackTo(slotItem, 32, 41, false) : index < 41 && !this.moveItemStackTo(slotItem, 5, 32, false)))))) {
                return ItemStack.EMPTY;
            }
            if (slotItem.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotItem.getCount() == originalItem.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotItem);
        }
        return ItemStack.EMPTY;
    }

    protected boolean hasRecipe(ItemStack item) {
        Level level = ((WitchOvenBlockEntity)((Object)this.getBlockEntity())).getLevel();
        return level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(item), level).isPresent();
    }
}

