/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.menus;

import net.favouriteless.enchanted.common.blocks.entity.PoppetShelfBlockEntity;
import net.favouriteless.enchanted.common.init.EBlocks;
import net.favouriteless.enchanted.common.init.EMenuTypes;
import net.favouriteless.enchanted.common.items.poppets.PoppetItem;
import net.favouriteless.enchanted.common.util.MenuUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class PoppetShelfMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess containerAccess;

    public PoppetShelfMenu(int id, Inventory playerInventory, PoppetShelfBlockEntity be) {
        super(EMenuTypes.POPPET_SHELF.get(), id);
        for (int i = 0; i < be.getInventory().getContainerSize(); ++i) {
            this.addSlot(new PoppetSlot(be.getInventory(), i, 47 + i * 22, 18));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventory, x + y * 9 + 9, 8 + x * 18, 49 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)playerInventory, x, 8 + 18 * x, 107));
        }
        this.containerAccess = ContainerLevelAccess.create((Level)be.getLevel(), (BlockPos)be.getBlockPos());
    }

    public PoppetShelfMenu(int id, Inventory playerInventory, BlockPos pos) {
        this(id, playerInventory, MenuUtils.getBlockEntity(playerInventory, pos, PoppetShelfBlockEntity.class));
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotItem = slot.getItem();
            ItemStack originalItem = slotItem.copy();
            if (index < 4 ? !this.moveItemStackTo(slotItem, 4, 40, true) : !this.moveItemStackTo(slotItem, 0, 4, false)) {
                return ItemStack.EMPTY;
            }
            if (slotItem.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotItem.getCount() == originalItem.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, slotItem);
        }
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return PoppetShelfMenu.stillValid((ContainerLevelAccess)this.containerAccess, (Player)player, (Block)((Block)EBlocks.POPPET_SHELF.get()));
    }

    public static class PoppetSlot
    extends Slot {
        public PoppetSlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean mayPlace(ItemStack itemStack) {
            return itemStack.getItem() instanceof PoppetItem;
        }
    }
}

