/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.menus;

import net.favouriteless.enchanted.common.blocks.entity.ContainerBlockEntityBase;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.Block;

public abstract class MenuBase<T extends ContainerBlockEntityBase>
extends AbstractContainerMenu {
    protected final T blockEntity;
    protected final Block block;

    protected MenuBase(MenuType<?> type, int id, T blockEntity, Block block) {
        super(type, id);
        this.block = block;
        this.blockEntity = blockEntity;
    }

    public boolean stillValid(Player player) {
        return ((ContainerBlockEntityBase)((Object)this.blockEntity)).stillValid(player);
    }

    protected void addInventorySlots(Inventory playerInventory, int xStart, int yStart) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventory, x + y * 9 + 9, xStart + x * 18, yStart + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)playerInventory, x, 8 + 18 * x, yStart + 58));
        }
    }

    public T getBlockEntity() {
        return this.blockEntity;
    }
}

