/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.menus;

import net.favouriteless.enchanted.common.blocks.entity.DistilleryBlockEntity;
import net.favouriteless.enchanted.common.init.EBlocks;
import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.common.init.EMenuTypes;
import net.favouriteless.enchanted.common.menus.MenuBase;
import net.favouriteless.enchanted.common.menus.slots.JarInputSlot;
import net.favouriteless.enchanted.common.menus.slots.OutputSlot;
import net.favouriteless.enchanted.common.util.MenuUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class DistilleryMenu
extends MenuBase<DistilleryBlockEntity> {
    private final ContainerData data;

    public DistilleryMenu(int id, Inventory playerInventory, DistilleryBlockEntity be, ContainerData data) {
        super(EMenuTypes.DISTILLERY.get(), id, be, (Block)EBlocks.DISTILLERY.get());
        this.data = data;
        this.addSlot(new JarInputSlot(be, 0, 32, 35));
        this.addSlot(new Slot((Container)be, 1, 54, 25));
        this.addSlot(new Slot((Container)be, 2, 54, 45));
        this.addSlot(new OutputSlot(be, 3, 127, 7));
        this.addSlot(new OutputSlot(be, 4, 127, 26));
        this.addSlot(new OutputSlot(be, 5, 127, 45));
        this.addSlot(new OutputSlot(be, 6, 127, 64));
        this.addInventorySlots(playerInventory, 8, 84);
        this.addDataSlots(data);
    }

    public DistilleryMenu(int id, Inventory playerInventory, BlockPos pos) {
        this(id, playerInventory, MenuUtils.getBlockEntity(playerInventory, pos, DistilleryBlockEntity.class), (ContainerData)new SimpleContainerData(2));
    }

    public int getCookProgress() {
        return this.data.get(0);
    }

    public int getCookDuration() {
        return this.data.get(1);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotItem = slot.getItem();
            ItemStack itemstack = slotItem.copy();
            if (index < 7 ? !this.moveItemStackTo(slotItem, 7, 43, true) : (itemstack.getItem() == EItems.CLAY_JAR.get() ? !this.moveItemStackTo(slotItem, 0, 1, false) : (index < 34 ? this.moveItemStackTo(slotItem, 1, 3, false) || !this.moveItemStackTo(slotItem, 34, 43, false) : this.moveItemStackTo(slotItem, 1, 3, false) || !this.moveItemStackTo(slotItem, 7, 34, false)))) {
                return ItemStack.EMPTY;
            }
            if (slotItem.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotItem.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotItem);
        }
        return ItemStack.EMPTY;
    }
}

