/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.items.poppets;

import java.util.List;
import net.favouriteless.enchanted.common.entities.VoodooItemEntity;
import net.favouriteless.enchanted.common.init.EDamageTypes;
import net.favouriteless.enchanted.common.init.EEntityTypes;
import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.common.items.poppets.PoppetItem;
import net.favouriteless.enchanted.common.poppet.PoppetUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class VoodooPoppetItem
extends PoppetItem {
    public VoodooPoppetItem(Item.Properties properties) {
        super(null, properties);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (PoppetUtils.isBound(stack) && entity instanceof Player) {
            ServerLevel serverLevel;
            ServerPlayer target;
            Player player = (Player)entity;
            ItemStack offHand = player.getOffhandItem();
            if (offHand.getItem() == EItems.BONE_NEEDLE.get() || offHand.getItem() == EItems.ICY_NEEDLE.get()) {
                ServerLevel serverLevel2;
                ServerPlayer target2;
                if (PoppetUtils.isBound(stack) && level instanceof ServerLevel && (target2 = PoppetUtils.getBoundPlayer(stack, serverLevel2 = (ServerLevel)level)) != null && !target2.isCreative() && PoppetUtils.tryVoodooPlayer(target2, (ServerPlayer)player, stack)) {
                    target2.hurt(EDamageTypes.source(level, EDamageTypes.VOODOO, (Entity)player), 2.0f);
                    stack.hurtAndBreak(2, (LivingEntity)player, EquipmentSlot.MAINHAND);
                    offHand.shrink(1);
                }
            } else if (level instanceof ServerLevel && (target = PoppetUtils.getBoundPlayer(stack, serverLevel = (ServerLevel)level)) != null && !target.isCreative() && PoppetUtils.tryVoodooPlayer(target, (ServerPlayer)player, stack)) {
                target.addDeltaMovement(player.getLookAngle().normalize().scale(1.0));
                target.hurtMarked = true;
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
        }
        return super.finishUsingItem(stack, level, entity);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack;
        if (hand == InteractionHand.MAIN_HAND && PoppetUtils.isBound(stack = player.getMainHandItem())) {
            player.startUsingItem(hand);
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
        }
        return super.use(level, player, hand);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (PoppetUtils.isBound(stack)) {
            tooltip.add((Component)Component.literal((String)PoppetUtils.getBoundName(stack)).withStyle(ChatFormatting.RED));
        }
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(Level level, Entity item, ItemStack stack) {
        ItemEntity itemEntity;
        VoodooItemEntity voodoo = new VoodooItemEntity(EEntityTypes.VOODOO_ITEM.get(), level);
        voodoo.setPos(item.position());
        voodoo.setDeltaMovement(item.getDeltaMovement());
        voodoo.setItem(stack);
        voodoo.setPickUpDelay(40);
        if (item instanceof ItemEntity && (itemEntity = (ItemEntity)item).getOwner() != null) {
            voodoo.setThrower(itemEntity.getOwner());
        }
        return voodoo;
    }
}

