/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.items.poppets;

import java.util.List;
import java.util.UUID;
import net.favouriteless.enchanted.common.items.TaglockFilledItem;
import net.favouriteless.enchanted.common.items.component.EDataComponents;
import net.favouriteless.enchanted.common.items.component.EntityRefData;
import net.favouriteless.enchanted.common.poppet.PoppetColour;
import net.favouriteless.enchanted.common.poppet.PoppetUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class PoppetItem
extends Item {
    public final PoppetColour colour;

    public PoppetItem(PoppetColour colour, Item.Properties properties) {
        super(properties);
        this.colour = colour;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> toolTip, TooltipFlag flag) {
        if (PoppetUtils.isBound(stack)) {
            toolTip.add((Component)Component.literal((String)PoppetUtils.getBoundName(stack)).withStyle(ChatFormatting.GRAY));
        }
    }

    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity entity) {
        UUID uuid;
        Player target;
        Player player;
        ItemStack taglock;
        if (entity instanceof Player && (taglock = (player = (Player)entity).getOffhandItem()).getItem() instanceof TaglockFilledItem && taglock.has(EDataComponents.ENTITY_REF.get()) && (target = level.getPlayerByUUID(uuid = ((EntityRefData)taglock.get(EDataComponents.ENTITY_REF.get())).uuid())) != null) {
            PoppetUtils.bind(itemStack, target);
            if (!player.isCreative()) {
                taglock.shrink(1);
            }
        }
        return itemStack;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        Player target;
        ItemStack taglock;
        if (hand == InteractionHand.MAIN_HAND && !PoppetUtils.isBound(player.getMainHandItem()) && (taglock = player.getOffhandItem()).getItem() instanceof TaglockFilledItem && taglock.has(EDataComponents.ENTITY_REF.get()) && (target = level.getPlayerByUUID(((EntityRefData)taglock.get(EDataComponents.ENTITY_REF.get())).uuid())) != null) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)player.getMainHandItem());
        }
        return super.use(level, player, hand);
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }
}

