/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.items.poppets;

import java.util.function.Predicate;
import net.favouriteless.enchanted.common.items.poppets.PoppetItem;
import net.favouriteless.enchanted.common.poppet.PoppetColour;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class DeathPoppetItem
extends PoppetItem {
    protected final Predicate<DamageSource> sourcePredicate;

    public DeathPoppetItem(PoppetColour colour, Predicate<DamageSource> sourcePredicate, Item.Properties properties) {
        super(colour, properties);
        this.sourcePredicate = sourcePredicate;
    }

    public boolean protectsAgainst(DamageSource damageSource) {
        return this.sourcePredicate.test(damageSource);
    }

    public void protect(Player player) {
        player.setHealth(1.0f);
        player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 1));
    }
}

