/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.items.brews;

import net.favouriteless.enchanted.common.entities.ThrowableBrew;
import net.favouriteless.enchanted.common.init.EEntityTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class ThrowableBrewItem
extends Item {
    public ThrowableBrewItem(Item.Properties properties) {
        super(properties);
    }

    public abstract void applyEffect(Entity var1, Level var2, Vec3 var3);

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SPLASH_POTION_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        ItemStack itemstack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            ThrowableBrew entity = (ThrowableBrew)EEntityTypes.THROWABLE_BREW.get().create(level);
            entity.setOwner((Entity)player);
            entity.setPos(player.getEyePosition().add(0.0, -0.1, 0.0));
            entity.setItem(itemstack);
            entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.5f, 1.0f);
            level.addFreshEntity((Entity)entity);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    public abstract int getColour();
}

