/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.items;

import net.favouriteless.enchanted.api.MutagenManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class MutandisItem
extends Item {
    private final boolean isExtremis;

    public MutandisItem(boolean isExtremis) {
        super(new Item.Properties());
        this.isExtremis = isExtremis;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (MutagenManager.get().tryStartMutating(serverLevel, pos, this.isExtremis)) {
                if (!context.getPlayer().isCreative()) {
                    context.getItemInHand().shrink(1);
                }
                serverLevel.playSound(null, pos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.MASTER);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.WITCH, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 25, 0.5, 0.5, 0.5, 0.0);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

