/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.items;

import net.favouriteless.enchanted.api.taglock.BedTaglockSavedData;
import net.favouriteless.enchanted.api.taglock.IBedTaglock;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.blocks.crops.BloodPoppyBlock;
import net.favouriteless.enchanted.common.blocks.entity.BloodPoppyBlockEntity;
import net.favouriteless.enchanted.common.init.EBlocks;
import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.common.init.ETags;
import net.favouriteless.enchanted.common.items.component.EDataComponents;
import net.favouriteless.enchanted.common.items.component.EntityRefData;
import net.favouriteless.enchanted.common.util.ItemUtils;
import net.favouriteless.enchanted.common.util.LangUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class EmptyTaglockItem
extends Item {
    public EmptyTaglockItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (target.getType().is(ETags.EntityTypes.TAGLOCK_BLACKLIST)) {
            return InteractionResult.PASS;
        }
        if (!player.level().isClientSide) {
            double failChance = 0.2;
            if (!player.isCrouching()) {
                failChance += 0.2;
            }
            if (!this.facingAway(player, (Entity)target)) {
                failChance += 0.4;
            }
            if (target.getType() != EntityType.PLAYER) {
                failChance = 0.0;
            }
            if (Math.random() >= failChance) {
                this.fillTaglockEntity(player, stack, target);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)LangUtils.key("taglock", "failed")).withStyle(ChatFormatting.RED), false);
                if (target instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)target;
                    sp.displayClientMessage((Component)Component.translatable((String)LangUtils.key("taglock", "failed.player"), (Object[])new Object[]{player.getDisplayName().getString()}).withStyle(ChatFormatting.RED), false);
                }
            }
        }
        return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockState state = level.getBlockState(context.getClickedPos());
        BlockPos pos = context.getClickedPos();
        if (state.getBlock() instanceof BedBlock) {
            if (!level.isClientSide) {
                BlockEntity be;
                BlockEntity blockEntity = be = state.getValue((Property)BedBlock.PART) == BedPart.HEAD ? level.getBlockEntity(pos) : level.getBlockEntity(pos.relative(BedBlock.getConnectedDirection((BlockState)state)));
                if (be instanceof BedBlockEntity) {
                    BedBlockEntity bed = (BedBlockEntity)be;
                    BedTaglockSavedData data = BedTaglockSavedData.get(level);
                    IBedTaglock entry = data.getEntry((BlockEntity)bed);
                    if (entry == null) {
                        return InteractionResult.CONSUME;
                    }
                    this.fillTaglock(context.getPlayer(), context.getItemInHand(), entry.getData());
                    entry.setData(null);
                    data.setDirty();
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (state.getBlock() == EBlocks.BLOOD_POPPY.get()) {
            BlockEntity blockEntity;
            if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof BloodPoppyBlockEntity) {
                BloodPoppyBlockEntity poppy = (BloodPoppyBlockEntity)blockEntity;
                this.fillTaglock(context.getPlayer(), context.getItemInHand(), poppy.getTaglockData());
                BloodPoppyBlock.reset(level, pos);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    protected void fillTaglockEntity(Player player, ItemStack stack, LivingEntity entity) {
        this.fillTaglock(player, stack, EntityRefData.of(entity.getUUID(), entity.getDisplayName().getString()));
    }

    protected void fillTaglock(Player player, ItemStack stack, EntityRefData data) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack item = new ItemStack((ItemLike)EItems.TAGLOCK_FILLED.get(), 1);
            item.set(EDataComponents.ENTITY_REF.get(), (Object)data);
            ItemUtils.giveOrDrop(player, item);
            serverPlayer.connection.send((Packet)new ClientboundSoundPacket(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.EXPERIENCE_ORB_PICKUP), SoundSource.MASTER, serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), 1.0f, 1.0f, Enchanted.RANDOM.nextLong()));
            stack.shrink(1);
        }
    }

    protected boolean facingAway(Player source, Entity target) {
        Vec3 sourceLook = source.getLookAngle().normalize();
        Vec3 targetLook = target.getLookAngle().normalize();
        Vec2 v1 = new Vec2((float)sourceLook.x, (float)sourceLook.z);
        Vec2 v2 = new Vec2((float)targetLook.x, (float)targetLook.z);
        return !(Math.acos((v1.x * v2.x + v1.y * v2.y) / (Mth.sqrt((float)(v1.x * v1.x + v1.y * v1.y)) * Mth.sqrt((float)(v2.x * v2.x + v2.y * v2.y)))) > 1.5707963705062866);
    }
}

