/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.items;

import net.favouriteless.enchanted.common.init.EDamageTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CreeperHeartItem
extends Item {
    public CreeperHeartItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        Vec3 pos = entity.position();
        if (!level.isClientSide) {
            entity.hurt(EDamageTypes.source(level, EDamageTypes.INTERNAL_EXPLOSION, (Entity)entity), Float.MAX_VALUE);
            level.playSound(null, pos.x, pos.y, pos.z, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
            stack.shrink(1);
        } else {
            level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
        }
        return stack;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)level.isClientSide);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.EAT;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 30;
    }
}

