/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.items;

import java.util.HashMap;
import java.util.Map;
import net.favouriteless.enchanted.common.circle_magic.CircleMagicShape;
import net.favouriteless.enchanted.common.init.EBlocks;
import net.favouriteless.enchanted.common.init.EData;
import net.favouriteless.enchanted.common.items.component.EDataComponents;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;

public class CircleTalismanItem
extends Item {
    public CircleTalismanItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (!level.isClientSide) {
            boolean valid;
            ItemStack stack = context.getItemInHand();
            if (!(stack.getItem() instanceof CircleTalismanItem)) {
                return InteractionResult.CONSUME;
            }
            Registry registry = level.registryAccess().registryOrThrow(EData.CIRCLE_SHAPE_REGISTRY);
            BlockPos clicked = context.getClickedPos();
            BlockPos pos = level.getBlockState(clicked).canBeReplaced() ? clicked : clicked.above();
            Map shapes = (Map)stack.get(EDataComponents.CIRCLE_MAGIC_SHAPE_MAP.get());
            if (shapes.isEmpty()) {
                return InteractionResult.CONSUME;
            }
            boolean bl = valid = level.getBlockState(pos).canBeReplaced() && EBlocks.GOLDEN_CHALK.get().canSurvive(null, (LevelReader)level, pos);
            if (!valid) {
                return this.sendFail(context.getPlayer());
            }
            HashMap<CircleMagicShape, Block> toPlace = new HashMap<CircleMagicShape, Block>();
            for (ResourceLocation location : shapes.keySet()) {
                CircleMagicShape shape2 = (CircleMagicShape)registry.get(location);
                if (shape2 == null) continue;
                if (!shape2.canPlace(level, pos)) {
                    return this.sendFail(context.getPlayer());
                }
                toPlace.put(shape2, (Block)shapes.get(location));
            }
            toPlace.forEach((shape, block) -> shape.place(level, pos, (Block)block, context));
            level.setBlockAndUpdate(pos, EBlocks.GOLDEN_CHALK.get().getRandomState());
            stack.set(EDataComponents.CIRCLE_MAGIC_SHAPE_MAP.get(), new HashMap());
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected InteractionResult sendFail(Player player) {
        if (player != null) {
            player.displayClientMessage((Component)Component.literal((String)"All blocks must be valid spots.").withStyle(ChatFormatting.RED), true);
        }
        return InteractionResult.CONSUME;
    }
}

