/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.items;

import net.favouriteless.enchanted.common.blocks.chalk.AbstractChalkBlock;
import net.favouriteless.enchanted.common.init.ESoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ChalkItem
extends BlockItem {
    private final AbstractChalkBlock chalkBlock;

    public ChalkItem(AbstractChalkBlock block, Item.Properties properties) {
        super((Block)block, properties);
        this.chalkBlock = block;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        if (context.getClickedFace() != Direction.UP) {
            return InteractionResult.PASS;
        }
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        if (state.getBlock() instanceof AbstractChalkBlock) {
            this.tryPlaceChalk(level, pos, context);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        BlockPos targetPos = pos.above();
        BlockState targetState = level.getBlockState(targetPos);
        if (targetState.canBeReplaced() && this.chalkBlock.canSurvive(this.chalkBlock.defaultBlockState(), (LevelReader)level, targetPos)) {
            this.tryPlaceChalk(level, targetPos, context);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private void tryPlaceChalk(Level level, BlockPos pos, UseOnContext context) {
        if (!level.isClientSide) {
            level.setBlockAndUpdate(pos, this.chalkBlock.getRandomState());
        }
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        level.playSound(player, pos, (SoundEvent)ESoundEvents.CHALK_WRITE.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
        player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
    }
}

