/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.items;

import net.favouriteless.enchanted.common.entities.Broomstick;
import net.favouriteless.enchanted.common.init.EEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class BroomstickItem
extends Item {
    public BroomstickItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isFoil(ItemStack pStack) {
        return true;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (!level.isClientSide) {
            BlockPos pos = context.getClickedPos().relative(context.getClickedFace());
            Broomstick broom = (Broomstick)EEntityTypes.BROOMSTICK.get().create(level);
            broom.setPos((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
            broom.setYRot(player.getYRot());
            level.addFreshEntity((Entity)broom);
            if (!player.getAbilities().instabuild) {
                context.getItemInHand().shrink(1);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

