/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.items;

import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.init.EBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class AnointingPasteItem
extends Item {
    public AnointingPasteItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        if (!level.getBlockState(pos = context.getClickedPos()).is(Blocks.CAULDRON)) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide) {
            level.setBlockAndUpdate(pos, EBlocks.WITCH_CAULDRON.get().defaultBlockState());
            context.getItemInHand().shrink(1);
        } else {
            level.playSound(context.getPlayer(), pos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            AnointingPasteItem.spawnParticles(level, pos);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public static void spawnParticles(Level level, BlockPos pos) {
        for (int i = 0; i < 20; ++i) {
            double x = Enchanted.RANDOM.nextDouble() * 2.0;
            double y = Enchanted.RANDOM.nextDouble() * 1.5;
            double z = Enchanted.RANDOM.nextDouble() * 2.0;
            level.addParticle((ParticleOptions)ParticleTypes.WITCH, (double)pos.getX() - 0.5 + x, (double)pos.getY() + y, (double)pos.getZ() - 0.5 + z, 0.0, 0.0, 0.0);
        }
    }
}

