/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.init;

import net.favouriteless.enchanted.common.Enchanted;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;

public class ETags {
    private static <T> TagKey<T> createTag(ResourceKey<? extends Registry<T>> registry, String name) {
        return TagKey.create(registry, (ResourceLocation)Enchanted.id(name));
    }

    public static TagKey<Item> createItemTag(String name) {
        return ETags.createTag(Registries.ITEM, name);
    }

    public static TagKey<Block> createBlockTag(String name) {
        return ETags.createTag(Registries.BLOCK, name);
    }

    public static TagKey<EntityType<?>> createEntityTag(String name) {
        return ETags.createTag(Registries.ENTITY_TYPE, name);
    }

    public static TagKey<Biome> createBiomeTag(String name) {
        return ETags.createTag(Registries.BIOME, name);
    }

    public static TagKey<MobEffect> createEffectTag(String name) {
        return ETags.createTag(Registries.MOB_EFFECT, name);
    }

    public static class EntityTypes {
        public static final TagKey<EntityType<?>> GROTESQUE_IMMUNE = ETags.createEntityTag("grotesque_immune");
        public static final TagKey<EntityType<?>> MONSTERS = ETags.createEntityTag("monsters");
        public static final TagKey<EntityType<?>> TAGLOCK_BLACKLIST = ETags.createEntityTag("taglock_blacklist");
    }

    public static class Biomes {
        public static final TagKey<Biome> OVERHEATING_BIOMES = ETags.createBiomeTag("overheating_biomes");
    }

    public static class MobEffects {
        public static final TagKey<MobEffect> MISFORTUNE_EFFECTS = ETags.createEffectTag("misfortune_effects");
        public static final TagKey<MobEffect> BLIGHT_EFFECTS = ETags.createEffectTag("blight_effects");
        public static final TagKey<MobEffect> FERTILITY_CURE_EFFECTS = ETags.createEffectTag("fertility_cure_effects");
    }

    public static class Items {
        public static final TagKey<Item> ALDER_LOGS = ETags.createItemTag("alder_logs");
        public static final TagKey<Item> ARMORS = ETags.createItemTag("armors");
        public static final TagKey<Item> ARMOR_POPPET_BLACKLIST = ETags.createItemTag("armor_poppet_blacklist");
        public static final TagKey<Item> CHALICES = ETags.createItemTag("chalices");
        public static final TagKey<Item> CHALKS = ETags.createItemTag("chalks");
        public static final TagKey<Item> LEAVES = ETags.createItemTag("leaves");
        public static final TagKey<Item> FENCE_GATES = ETags.createItemTag("fence_gates");
        public static final TagKey<Item> HAWTHORN_LOGS = ETags.createItemTag("hawthorn_logs");
        public static final TagKey<Item> LOGS = ETags.createItemTag("logs");
        public static final TagKey<Item> PLANKS = ETags.createItemTag("planks");
        public static final TagKey<Item> RAW_FOODS = ETags.createItemTag("raw_foods");
        public static final TagKey<Item> ROWAN_LOGS = ETags.createItemTag("rowan_logs");
        public static final TagKey<Item> SAPLINGS = ETags.createItemTag("saplings");
        public static final TagKey<Item> SLABS = ETags.createItemTag("slabs");
        public static final TagKey<Item> STAIRS = ETags.createItemTag("stairs");
        public static final TagKey<Item> SWORDS = ETags.createItemTag("swords");
        public static final TagKey<Item> TOOLS = ETags.createItemTag("tools");
        public static final TagKey<Item> TOOL_POPPET_BLACKLIST = ETags.createItemTag("tool_poppet_blacklist");
        public static final TagKey<Item> TOOL_POPPET_WHITELIST = ETags.createItemTag("tool_poppet_whitelist");
        public static final TagKey<Item> WITCH_OVEN_BLACKLIST = ETags.createItemTag("witch_oven_blacklist");
        public static final TagKey<Item> WOODEN_BUTTONS = ETags.createItemTag("wooden_buttons");
        public static final TagKey<Item> WOODEN_FENCES = ETags.createItemTag("wooden_fences");
        public static final TagKey<Item> WOODEN_PRESSURE_PLATES = ETags.createItemTag("wooden_pressure_plates");
        public static final TagKey<Item> WOODEN_SLABS = ETags.createItemTag("wooden_slabs");
        public static final TagKey<Item> WOODEN_STAIRS = ETags.createItemTag("wooden_stairs");
    }

    public static class Blocks {
        public static final TagKey<Block> ALDER_LOGS = ETags.createBlockTag("alder_logs");
        public static final TagKey<Block> BLIGHT_DECAYABLE_BLOCKS = ETags.createBlockTag("blight_decayable_blocks");
        public static final TagKey<Block> BLIGHT_DECAYABLE_PLANTS = ETags.createBlockTag("blight_decayable_plants");
        public static final TagKey<Block> BLIGHT_DECAY_BLOCKS = ETags.createBlockTag("blight_decay_blocks");
        public static final TagKey<Block> BROOM_SWEEPABLE = ETags.createBlockTag("broom_sweepable");
        public static final TagKey<Block> CHALICES = ETags.createBlockTag("chalices");
        public static final TagKey<Block> CHALKS = ETags.createBlockTag("chalks");
        public static final TagKey<Block> CROPS = ETags.createBlockTag("crops");
        public static final TagKey<Block> EMBER_MOSS_SPREADS_ON = ETags.createBlockTag("ember_moss_spreads_on");
        public static final TagKey<Block> FENCES = ETags.createBlockTag("fences");
        public static final TagKey<Block> FENCE_GATES = ETags.createBlockTag("fence_gates");
        public static final TagKey<Block> GLINT_WEED_SPREADS_ON = ETags.createBlockTag("glint_weed_spreads_on");
        public static final TagKey<Block> HAWTHORN_LOGS = ETags.createBlockTag("hawthorn_logs");
        public static final TagKey<Block> HEAT_SOURCES = ETags.createBlockTag("heat_sources");
        public static final TagKey<Block> LEAVES = ETags.createBlockTag("leaves");
        public static final TagKey<Block> LOGS = ETags.createBlockTag("logs");
        public static final TagKey<Block> MUTANDIS_BLACKLIST = ETags.createBlockTag("mutandis_blacklist");
        public static final TagKey<Block> MUTANDIS_EXTREMIS_BLACKLIST = ETags.createBlockTag("mutandis_extremis_blacklist");
        public static final TagKey<Block> MUTANDIS_EXTREMIS = ETags.createBlockTag("mutandis_extremis");
        public static final TagKey<Block> MUTANDIS = ETags.createBlockTag("mutandis");
        public static final TagKey<Block> PLANKS = ETags.createBlockTag("planks");
        public static final TagKey<Block> RITE_FOREST_REPLACEABLE = ETags.createBlockTag("rite_forest_replaceable");
        public static final TagKey<Block> ROWAN_LOGS = ETags.createBlockTag("rowan_logs");
        public static final TagKey<Block> SAPLINGS = ETags.createBlockTag("saplings");
        public static final TagKey<Block> SLABS = ETags.createBlockTag("slabs");
        public static final TagKey<Block> STAIRS = ETags.createBlockTag("stairs");
        public static final TagKey<Block> TRANSPOSE_IRON = ETags.createBlockTag("transpose_iron");
        public static final TagKey<Block> WOODEN_BUTTONS = ETags.createBlockTag("wooden_buttons");
        public static final TagKey<Block> WOODEN_FENCES = ETags.createBlockTag("wooden_fences");
        public static final TagKey<Block> WOODEN_PRESSURE_PLATES = ETags.createBlockTag("wooden_pressure_plates");
        public static final TagKey<Block> WOODEN_SLABS = ETags.createBlockTag("wooden_slabs");
        public static final TagKey<Block> WOODEN_STAIRS = ETags.createBlockTag("wooden_stairs");
    }
}

