/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.init;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.favouriteless.enchanted.common.blocks.chalk.AbstractChalkBlock;
import net.favouriteless.enchanted.common.init.EBlocks;
import net.favouriteless.enchanted.common.init.EMobEffects;
import net.favouriteless.enchanted.common.items.AnointingPasteItem;
import net.favouriteless.enchanted.common.items.ArtichokeSeedsItem;
import net.favouriteless.enchanted.common.items.BloodedWaystoneItem;
import net.favouriteless.enchanted.common.items.BoundWaystoneItem;
import net.favouriteless.enchanted.common.items.BroomItem;
import net.favouriteless.enchanted.common.items.BroomstickItem;
import net.favouriteless.enchanted.common.items.ChalkItem;
import net.favouriteless.enchanted.common.items.CircleTalismanItem;
import net.favouriteless.enchanted.common.items.CreeperHeartItem;
import net.favouriteless.enchanted.common.items.EarmuffsItem;
import net.favouriteless.enchanted.common.items.EmptyTaglockItem;
import net.favouriteless.enchanted.common.items.MutandisItem;
import net.favouriteless.enchanted.common.items.TaglockFilledItem;
import net.favouriteless.enchanted.common.items.WaystoneItem;
import net.favouriteless.enchanted.common.items.brews.SimpleEffectBrewItem;
import net.favouriteless.enchanted.common.items.brews.throwable.LoveBrewItem;
import net.favouriteless.enchanted.common.items.component.EDataComponents;
import net.favouriteless.enchanted.common.items.poppets.DeathPoppetEffectItem;
import net.favouriteless.enchanted.common.items.poppets.DeathPoppetItem;
import net.favouriteless.enchanted.common.items.poppets.FirePoppetEffectItem;
import net.favouriteless.enchanted.common.items.poppets.FirePoppetItem;
import net.favouriteless.enchanted.common.items.poppets.ItemProtectionPoppetItem;
import net.favouriteless.enchanted.common.items.poppets.PoppetItem;
import net.favouriteless.enchanted.common.items.poppets.VoidPoppetEffectItem;
import net.favouriteless.enchanted.common.items.poppets.VoidPoppetItem;
import net.favouriteless.enchanted.common.items.poppets.VoodooPoppetItem;
import net.favouriteless.enchanted.common.poppet.PoppetColour;
import net.favouriteless.enchanted.platform.CommonServices;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;

public class EItems {
    public static final Supplier<BlockItem> ALDER_BUTTON = EItems.registerBlock("alder_button", EBlocks.ALDER_BUTTON);
    public static final Supplier<BlockItem> ALDER_FENCE = EItems.registerBlock("alder_fence", EBlocks.ALDER_FENCE);
    public static final Supplier<BlockItem> ALDER_FENCE_GATE = EItems.registerBlock("alder_fence_gate", EBlocks.ALDER_FENCE_GATE);
    public static final Supplier<BlockItem> ALDER_LEAVES = EItems.registerBlock("alder_leaves", EBlocks.ALDER_LEAVES);
    public static final Supplier<BlockItem> ALDER_LOG = EItems.registerBlock("alder_log", EBlocks.ALDER_LOG);
    public static final Supplier<BlockItem> ALDER_PLANKS = EItems.registerBlock("alder_planks", EBlocks.ALDER_PLANKS);
    public static final Supplier<BlockItem> ALDER_PRESSURE_PLATE = EItems.registerBlock("alder_pressure_plate", EBlocks.ALDER_PRESSURE_PLATE);
    public static final Supplier<BlockItem> ALDER_SAPLING = EItems.registerBlock("alder_sapling", EBlocks.ALDER_SAPLING);
    public static final Supplier<BlockItem> ALDER_SLAB = EItems.registerBlock("alder_slab", EBlocks.ALDER_SLAB);
    public static final Supplier<BlockItem> ALDER_STAIRS = EItems.registerBlock("alder_stairs", EBlocks.ALDER_STAIRS);
    public static final Supplier<BlockItem> ALTAR = EItems.registerBlock("altar", EBlocks.ALTAR);
    public static final Supplier<Item> ANOINTING_PASTE = EItems.register("anointing_paste", () -> new AnointingPasteItem(EItems.props()));
    public static final Supplier<Item> ARMOUR_POPPET = EItems.register("armour_poppet", () -> new ItemProtectionPoppetItem(0.9f, PoppetColour.EQUIPMENT, EItems.poppetProps(1)));
    public static final Supplier<Item> ARMOUR_POPPET_INFUSED = EItems.register("infused_armour_poppet", () -> new ItemProtectionPoppetItem(0.0f, PoppetColour.EQUIPMENT, EItems.poppetProps(1)));
    public static final Supplier<Item> ARMOUR_POPPET_STURDY = EItems.register("sturdy_armour_poppet", () -> new ItemProtectionPoppetItem(0.9f, PoppetColour.EQUIPMENT, EItems.poppetProps(2)));
    public static final Supplier<SwordItem> ARTHANA = EItems.registerSword("arthana", (Tier)Tiers.GOLD, 3, -2.4f);
    public static final Supplier<Item> ATTUNED_STONE = EItems.registerItem("attuned_stone");
    public static final Supplier<Item> ATTUNED_STONE_CHARGED = EItems.registerItem("attuned_stone_charged", EItems.props().component(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true).rarity(Rarity.UNCOMMON));
    public static final Supplier<Item> BELLADONNA_FLOWER = EItems.registerItem("belladonna_flower");
    public static final Supplier<ItemNameBlockItem> BELLADONNA_SEEDS = EItems.registerBlockNamed("belladonna_seeds", EBlocks.BELLADONNA);
    public static final Supplier<BloodedWaystoneItem> BLOODED_WAYSTONE = EItems.register("blooded_waystone", () -> new BloodedWaystoneItem(EItems.props()));
    public static final Supplier<BoundWaystoneItem> BOUND_WAYSTONE = EItems.register("bound_waystone", () -> new BoundWaystoneItem(EItems.props()));
    public static final Supplier<BlockItem> BLOOD_POPPY = EItems.registerBlock("blood_poppy", EBlocks.BLOOD_POPPY, EItems.props().rarity(Rarity.UNCOMMON));
    public static final Supplier<Item> BONE_NEEDLE = EItems.registerItem("bone_needle");
    public static final Supplier<Item> BREATH_OF_THE_GODDESS = EItems.registerItem("breath_of_the_goddess");
    public static final Supplier<Item> BREW_OF_LOVE = EItems.register("brew_of_love", LoveBrewItem::new);
    public static final Supplier<Item> BREW_OF_SPROUTING = EItems.registerItem("brew_of_sprouting");
    public static final Supplier<SimpleEffectBrewItem> BREW_OF_THE_DEPTHS = EItems.registerBrew("brew_of_the_depths", () -> MobEffects.WATER_BREATHING, 12000, 0);
    public static final Supplier<SimpleEffectBrewItem> BREW_OF_THE_GROTESQUE = EItems.registerBrew("brew_of_the_grotesque", () -> EMobEffects.GROTESQUE, 6000, 0);
    public static final Supplier<Item> BROOM = EItems.register("broom", () -> new BroomItem(EItems.props().stacksTo(1)));
    public static final Supplier<BlockItem> CANDELABRA = EItems.registerBlock("candelabra", EBlocks.CANDELABRA);
    public static final Supplier<BlockItem> CHALICE = EItems.registerBlock("chalice", EBlocks.CHALICE);
    public static final Supplier<BlockItem> CHALICE_FILLED = EItems.registerBlock("chalice_filled", EBlocks.CHALICE_FILLED, EItems.props().rarity(Rarity.UNCOMMON));
    public static final Supplier<Item> CIRCLE_TALISMAN = EItems.register("circle_talisman", () -> new CircleTalismanItem(EItems.props().stacksTo(1).component(EDataComponents.CIRCLE_MAGIC_SHAPE_MAP.get(), new HashMap())));
    public static final Supplier<Item> CLAY_JAR = EItems.registerItem("clay_jar");
    public static final Supplier<Item> CONDENSED_FEAR = EItems.registerItem("condensed_fear");
    public static final Supplier<Item> CREEPER_HEART = EItems.register("creeper_heart", () -> new CreeperHeartItem(EItems.props()));
    public static final Supplier<Item> DEMONIC_BLOOD = EItems.registerItem("demonic_blood");
    public static final Supplier<Item> DEMON_HEART = EItems.registerItem("demon_heart");
    public static final Supplier<Item> DIAMOND_VAPOUR = EItems.registerItem("diamond_vapour");
    public static final Supplier<BlockItem> DISTILLERY = EItems.registerBlock("distillery", EBlocks.DISTILLERY);
    public static final Supplier<Item> DROP_OF_LUCK = EItems.registerItem("drop_of_luck");
    public static final Supplier<EarmuffsItem> EARMUFFS = EItems.register("earmuffs", () -> new EarmuffsItem((Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.HELMET, EItems.props().stacksTo(1).rarity(Rarity.RARE)));
    public static final Supplier<Item> EARTH_POPPET = EItems.register("earth_poppet", () -> new DeathPoppetItem(PoppetColour.EARTH, source -> source.is(DamageTypeTags.IS_FALL) || source.is(DamageTypes.FLY_INTO_WALL), EItems.poppetProps(1)));
    public static final Supplier<Item> EARTH_POPPET_INFUSED = EItems.register("infused_earth_poppet", () -> new DeathPoppetEffectItem(PoppetColour.EARTH, () -> new MobEffectInstance(EMobEffects.FALL_RESISTANCE, 200), source -> source.is(DamageTypeTags.IS_FALL) || source.is(DamageTypes.FLY_INTO_WALL), EItems.poppetProps(1)));
    public static final Supplier<Item> EARTH_POPPET_STURDY = EItems.register("sturdy_earth_poppet", () -> new DeathPoppetItem(PoppetColour.EARTH, source -> source.is(DamageTypeTags.IS_FALL) || source.is(DamageTypes.FLY_INTO_WALL), EItems.poppetProps(2)));
    public static final Supplier<BlockItem> EMBER_MOSS = EItems.registerBlock("ember_moss", EBlocks.EMBER_MOSS);
    public static final Supplier<Item> ENCHANTED_BROOMSTICK = EItems.register("enchanted_broomstick", () -> new BroomstickItem(EItems.props().stacksTo(1).rarity(Rarity.EPIC)));
    public static final Supplier<Item> ENDER_DEW = EItems.registerItem("ender_dew");
    public static final Supplier<Item> ENT_TWIG = EItems.registerItem("ent_twig");
    public static final Supplier<Item> EXHALE_OF_THE_HORNED_ONE = EItems.registerItem("exhale_of_the_horned_one");
    public static final Supplier<Item> FIRE_POPPET = EItems.register("fire_poppet", () -> new FirePoppetItem(PoppetColour.FIRE, source -> source.is(DamageTypeTags.IS_FIRE), EItems.poppetProps(1)));
    public static final Supplier<Item> FIRE_POPPET_INFUSED = EItems.register("infused_fire_poppet", () -> new FirePoppetEffectItem(PoppetColour.FIRE, () -> new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 200), source -> source.is(DamageTypeTags.IS_FIRE), EItems.poppetProps(1)));
    public static final Supplier<Item> FIRE_POPPET_STURDY = EItems.register("sturdy_fire_poppet", () -> new FirePoppetItem(PoppetColour.FIRE, source -> source.is(DamageTypeTags.IS_FIRE), EItems.poppetProps(2)));
    public static final Supplier<SimpleEffectBrewItem> FLYING_OINTMENT = EItems.registerBrew("flying_ointment", () -> MobEffects.LEVITATION, 1200, 0);
    public static final Supplier<Item> FOCUSED_WILL = EItems.registerItem("focused_will");
    public static final Supplier<Item> FOUL_FUME = EItems.registerItem("foul_fume");
    public static final Supplier<Item> FUME_FILTER = EItems.registerItem("fume_filter");
    public static final Supplier<BlockItem> FUME_FUNNEL = EItems.registerBlock("fume_funnel", EBlocks.FUME_FUNNEL);
    public static final Supplier<BlockItem> FUME_FUNNEL_FILTERED = EItems.registerBlock("fume_funnel_filtered", EBlocks.FUME_FUNNEL_FILTERED);
    public static final Supplier<ItemNameBlockItem> GARLIC = EItems.registerBlockNamed("garlic", EBlocks.GARLIC);
    public static final Supplier<SimpleEffectBrewItem> GHOST_OF_THE_LIGHT = EItems.registerBrew("ghost_of_the_light", () -> MobEffects.POISON, 1200, 1);
    public static final Supplier<BlockItem> GLINT_WEED = EItems.registerBlock("glint_weed", EBlocks.GLINT_WEED);
    public static final Supplier<ChalkItem> GOLDEN_CHALK = EItems.registerChalk("golden_chalk", EBlocks.GOLDEN_CHALK, 3);
    public static final Supplier<Item> GYPSUM = EItems.registerItem("gypsum");
    public static final Supplier<SimpleEffectBrewItem> HAPPENSTANCE_OIL = EItems.registerBrew("happenstance_oil", () -> MobEffects.NIGHT_VISION, 1200, 0);
    public static final Supplier<BlockItem> HAWTHORN_BUTTON = EItems.registerBlock("hawthorn_button", EBlocks.HAWTHORN_BUTTON);
    public static final Supplier<BlockItem> HAWTHORN_FENCE = EItems.registerBlock("hawthorn_fence", EBlocks.HAWTHORN_FENCE);
    public static final Supplier<BlockItem> HAWTHORN_FENCE_GATE = EItems.registerBlock("hawthorn_fence_gate", EBlocks.HAWTHORN_FENCE_GATE);
    public static final Supplier<BlockItem> HAWTHORN_LEAVES = EItems.registerBlock("hawthorn_leaves", EBlocks.HAWTHORN_LEAVES);
    public static final Supplier<BlockItem> HAWTHORN_LOG = EItems.registerBlock("hawthorn_log", EBlocks.HAWTHORN_LOG);
    public static final Supplier<BlockItem> HAWTHORN_PLANKS = EItems.registerBlock("hawthorn_planks", EBlocks.HAWTHORN_PLANKS);
    public static final Supplier<BlockItem> HAWTHORN_PRESSURE_PLATE = EItems.registerBlock("hawthorn_pressure_plate", EBlocks.HAWTHORN_PRESSURE_PLATE);
    public static final Supplier<BlockItem> HAWTHORN_SAPLING = EItems.registerBlock("hawthorn_sapling", EBlocks.HAWTHORN_SAPLING);
    public static final Supplier<BlockItem> HAWTHORN_SLAB = EItems.registerBlock("hawthorn_slab", EBlocks.HAWTHORN_SLAB);
    public static final Supplier<BlockItem> HAWTHORN_STAIRS = EItems.registerBlock("hawthorn_stairs", EBlocks.HAWTHORN_STAIRS);
    public static final Supplier<Item> HINT_OF_REBIRTH = EItems.registerItem("hint_of_rebirth");
    public static final Supplier<Item> HUNGER_POPPET = EItems.register("hunger_poppet", () -> new DeathPoppetEffectItem(PoppetColour.HUNGER, () -> new MobEffectInstance(MobEffects.SATURATION, 100, 4), source -> source.is(DamageTypes.STARVE), EItems.poppetProps(1)));
    public static final Supplier<Item> HUNGER_POPPET_INFUSED = EItems.register("infused_hunger_poppet", () -> new DeathPoppetEffectItem(PoppetColour.HUNGER, () -> new MobEffectInstance(MobEffects.SATURATION, 2400, 4), source -> source.is(DamageTypes.STARVE), EItems.poppetProps(1)));
    public static final Supplier<Item> HUNGER_POPPET_STURDY = EItems.register("sturdy_hunger_poppet", () -> new DeathPoppetItem(PoppetColour.HUNGER, source -> source.is(DamageTypes.STARVE), EItems.poppetProps(2)));
    public static final Supplier<Item> ICY_NEEDLE = EItems.registerItem("icy_needle");
    public static final Supplier<SimpleEffectBrewItem> INFERNAL_ANIMUS = EItems.registerBrew("infernal_animus", () -> MobEffects.WITHER, 1200, 2);
    public static final Supplier<BlockItem> INFINITY_EGG = EItems.registerBlock("infinity_egg", EBlocks.INFINITY_EGG);
    public static final Supplier<BlockItem> KETTLE = EItems.registerBlock("kettle", EBlocks.KETTLE);
    public static final Supplier<DeathPoppetItem> MAGIC_POPPET = EItems.register("magic_poppet", () -> new DeathPoppetItem(PoppetColour.MAGIC, EMobEffects::isMagic, EItems.poppetProps(1)));
    public static final Supplier<DeathPoppetEffectItem> MAGIC_POPPET_INFUSED = EItems.register("infused_magic_poppet", () -> new DeathPoppetEffectItem(PoppetColour.MAGIC, () -> new MobEffectInstance(EMobEffects.MAGIC_RESISTANCE, 200), EMobEffects::isMagic, EItems.poppetProps(1)));
    public static final Supplier<DeathPoppetItem> MAGIC_POPPET_STURDY = EItems.register("sturdy_magic_poppet", () -> new DeathPoppetItem(PoppetColour.MAGIC, EMobEffects::isMagic, EItems.poppetProps(2)));
    public static final Supplier<Item> MANDRAKE_ROOT = EItems.registerItem("mandrake_root");
    public static final Supplier<ItemNameBlockItem> MANDRAKE_SEEDS = EItems.registerBlockNamed("mandrake_seeds", EBlocks.MANDRAKE);
    public static final Supplier<Item> MELLIFLUOUS_HUNGER = EItems.registerItem("mellifluous_hunger");
    public static final Supplier<Item> MUTANDIS = EItems.register("mutandis", () -> new MutandisItem(false));
    public static final Supplier<Item> MUTANDIS_EXTREMIS = EItems.register("mutandis_extremis", () -> new MutandisItem(true));
    public static final Supplier<SimpleEffectBrewItem> MYSTIC_UNGUENT = EItems.registerBrew("mystic_unguent", () -> MobEffects.WEAKNESS, 1200, 1);
    public static final Supplier<ChalkItem> NETHER_CHALK = EItems.registerChalk("nether_chalk", EBlocks.NETHER_CHALK, 40);
    public static final Supplier<Item> ODOUR_OF_PURITY = EItems.registerItem("odour_of_purity");
    public static final Supplier<Item> OIL_OF_VITRIOL = EItems.registerItem("oil_of_vitriol");
    public static final Supplier<ChalkItem> OTHERWHERE_CHALK = EItems.registerChalk("otherwhere_chalk", EBlocks.OTHERWHERE_CHALK, 40);
    public static final Supplier<Item> POPPET = EItems.registerItem("poppet");
    public static final Supplier<Item> POPPET_INFUSED = EItems.registerItem("infused_poppet");
    public static final Supplier<BlockItem> POPPET_SHELF = EItems.registerBlock("poppet_shelf", EBlocks.POPPET_SHELF);
    public static final Supplier<Item> POPPET_STURDY = EItems.registerItem("sturdy_poppet");
    public static final Supplier<Item> PURIFIED_MILK = EItems.registerItem("purified_milk");
    public static final Supplier<Item> QUICKLIME = EItems.registerItem("quicklime");
    public static final Supplier<SimpleEffectBrewItem> REDSTONE_SOUP = EItems.registerBrew("redstone_soup", () -> MobEffects.ABSORPTION, 2400, 1);
    public static final Supplier<Item> REEK_OF_MISFORTUNE = EItems.registerItem("reek_of_misfortune");
    public static final Supplier<Item> REFINED_EVIL = EItems.registerItem("refined_evil");
    public static final Supplier<ChalkItem> RITUAL_CHALK = EItems.registerChalk("ritual_chalk", EBlocks.RITUAL_CHALK, 40);
    public static final Supplier<Item> ROWAN_BERRIES = EItems.registerFood("rowan_berries", 3, true);
    public static final Supplier<BlockItem> ROWAN_BUTTON = EItems.registerBlock("rowan_button", EBlocks.ROWAN_BUTTON);
    public static final Supplier<BlockItem> ROWAN_FENCE = EItems.registerBlock("rowan_fence", EBlocks.ROWAN_FENCE);
    public static final Supplier<BlockItem> ROWAN_FENCE_GATE = EItems.registerBlock("rowan_fence_gate", EBlocks.ROWAN_FENCE_GATE);
    public static final Supplier<BlockItem> ROWAN_LEAVES = EItems.registerBlock("rowan_leaves", EBlocks.ROWAN_LEAVES);
    public static final Supplier<BlockItem> ROWAN_LOG = EItems.registerBlock("rowan_log", EBlocks.ROWAN_LOG);
    public static final Supplier<BlockItem> ROWAN_PLANKS = EItems.registerBlock("rowan_planks", EBlocks.ROWAN_PLANKS);
    public static final Supplier<BlockItem> ROWAN_PRESSURE_PLATE = EItems.registerBlock("rowan_pressure_plate", EBlocks.ROWAN_PRESSURE_PLATE);
    public static final Supplier<BlockItem> ROWAN_SAPLING = EItems.registerBlock("rowan_sapling", EBlocks.ROWAN_SAPLING);
    public static final Supplier<BlockItem> ROWAN_SLAB = EItems.registerBlock("rowan_slab", EBlocks.ROWAN_SLAB);
    public static final Supplier<BlockItem> ROWAN_STAIRS = EItems.registerBlock("rowan_stairs", EBlocks.ROWAN_STAIRS);
    public static final Supplier<ItemNameBlockItem> SNOWBELL_SEEDS = EItems.registerBlockNamed("snowbell_seeds", EBlocks.SNOWBELL);
    public static final Supplier<Item> SOFT_CLAY_JAR = EItems.registerItem("soft_clay_jar");
    public static final Supplier<SimpleEffectBrewItem> SOUL_OF_THE_WORLD = EItems.registerBrew("soul_of_the_world", () -> MobEffects.POISON, 1200, 1);
    public static final Supplier<BlockItem> SPANISH_MOSS = EItems.registerBlock("spanish_moss", EBlocks.SPANISH_MOSS);
    public static final Supplier<Item> SPINNING_WHEEL = EItems.register("spinning_wheel", () -> new BlockItem((Block)EBlocks.SPINNING_WHEEL.get(), EItems.props()));
    public static final Supplier<SimpleEffectBrewItem> SPIRIT_OF_OTHERWHERE = EItems.registerBrew("spirit_of_otherwhere", () -> MobEffects.POISON, 1200, 1);
    public static final Supplier<BlockItem> STRIPPED_ALDER_LOG = EItems.registerBlock("stripped_alder_log", EBlocks.STRIPPED_ALDER_LOG);
    public static final Supplier<BlockItem> STRIPPED_HAWTHORN_LOG = EItems.registerBlock("stripped_hawthorn_log", EBlocks.STRIPPED_HAWTHORN_LOG);
    public static final Supplier<BlockItem> STRIPPED_ROWAN_LOG = EItems.registerBlock("stripped_rowan_log", EBlocks.STRIPPED_ROWAN_LOG);
    public static final Supplier<Item> TAGLOCK = EItems.register("taglock_kit", () -> new EmptyTaglockItem(EItems.props()));
    public static final Supplier<Item> TAGLOCK_FILLED = EItems.register("taglock", () -> new TaglockFilledItem(EItems.props()));
    public static final Supplier<Item> TEAR_OF_THE_GODDESS = EItems.registerItem("tear_of_the_goddess");
    public static final Supplier<Item> TONGUE_OF_DOG = EItems.registerItem("tongue_of_dog");
    public static final Supplier<Item> TOOL_POPPET = EItems.register("tool_poppet", () -> new ItemProtectionPoppetItem(0.9f, PoppetColour.EQUIPMENT, EItems.poppetProps(1)));
    public static final Supplier<Item> TOOL_POPPET_INFUSED = EItems.register("infused_tool_poppet", () -> new ItemProtectionPoppetItem(0.0f, PoppetColour.EQUIPMENT, EItems.poppetProps(1)));
    public static final Supplier<Item> TOOL_POPPET_STURDY = EItems.register("sturdy_tool_poppet", () -> new ItemProtectionPoppetItem(0.9f, PoppetColour.EQUIPMENT, EItems.poppetProps(2)));
    public static final Supplier<VoidPoppetItem> VOID_POPPET = EItems.register("void_poppet", () -> new VoidPoppetItem(PoppetColour.VOID, source -> source.is(DamageTypes.FELL_OUT_OF_WORLD), EItems.poppetProps(1)));
    public static final Supplier<VoidPoppetEffectItem> VOID_POPPET_INFUSED = EItems.register("infused_void_poppet", () -> new VoidPoppetEffectItem(PoppetColour.VOID, () -> new MobEffectInstance(EMobEffects.FALL_RESISTANCE, 200), source -> source.is(DamageTypes.FELL_OUT_OF_WORLD), EItems.poppetProps(1)));
    public static final Supplier<VoidPoppetItem> VOID_POPPET_STURDY = EItems.register("sturdy_void_poppet", () -> new VoidPoppetItem(PoppetColour.VOID, source -> source.is(DamageTypes.FELL_OUT_OF_WORLD), EItems.poppetProps(2)));
    public static final Supplier<VoodooPoppetItem> VOODOO_POPPET = EItems.register("voodoo_poppet", () -> new VoodooPoppetItem(EItems.props().stacksTo(1).durability(40).fireResistant()));
    public static final Supplier<Item> VOODOO_PROTECTION_POPPET = EItems.register("voodoo_protection_poppet", () -> new PoppetItem(PoppetColour.VOODOO_PROTECTION, EItems.poppetProps(1)));
    public static final Supplier<Item> VOODOO_PROTECTION_POPPET_INFUSED = EItems.register("infused_voodoo_protection_poppet", () -> new PoppetItem(PoppetColour.VOODOO_PROTECTION, EItems.poppetProps(1)));
    public static final Supplier<Item> VOODOO_PROTECTION_POPPET_STURDY = EItems.register("sturdy_voodoo_protection_poppet", () -> new PoppetItem(PoppetColour.VOODOO_PROTECTION, EItems.poppetProps(2)));
    public static final Supplier<Item> WATER_ARTICHOKE = EItems.registerFood("water_artichoke", 3, (Holder<MobEffect>)MobEffects.HUNGER, 100, 0, 1.0f);
    public static final Supplier<ArtichokeSeedsItem> WATER_ARTICHOKE_SEEDS = EItems.register("water_artichoke_seeds", () -> new ArtichokeSeedsItem(EItems.props()));
    public static final Supplier<DeathPoppetEffectItem> WATER_POPPET = EItems.register("water_poppet", () -> new DeathPoppetEffectItem(PoppetColour.WATER, () -> new MobEffectInstance(EMobEffects.DROWN_RESISTANCE, 100), source -> source.is(DamageTypeTags.IS_DROWNING), EItems.poppetProps(1)));
    public static final Supplier<DeathPoppetEffectItem> WATER_POPPET_INFUSED = EItems.register("infused_water_poppet", () -> new DeathPoppetEffectItem(PoppetColour.WATER, () -> new MobEffectInstance(MobEffects.WATER_BREATHING, 200), source -> source.is(DamageTypeTags.IS_DROWNING), EItems.poppetProps(1)));
    public static final Supplier<DeathPoppetEffectItem> WATER_POPPET_STURDY = EItems.register("sturdy_water_poppet", () -> new DeathPoppetEffectItem(PoppetColour.WATER, () -> new MobEffectInstance(EMobEffects.DROWN_RESISTANCE, 100), source -> source.is(DamageTypeTags.IS_DROWNING), EItems.poppetProps(2)));
    public static final Supplier<WaystoneItem> WAYSTONE = EItems.register("waystone", () -> new WaystoneItem(EItems.props()));
    public static final Supplier<Item> WHIFF_OF_MAGIC = EItems.registerItem("whiff_of_magic");
    public static final Supplier<BlockItem> WICKER_BUNDLE = EItems.registerBlock("wicker_bundle", EBlocks.WICKER_BUNDLE);
    public static final Supplier<BlockItem> WITCH_CAULDRON = EItems.registerBlock("witch_cauldron", EBlocks.WITCH_CAULDRON);
    public static final Supplier<BlockItem> WITCH_OVEN = EItems.registerBlock("witch_oven", EBlocks.WITCH_OVEN);
    public static final Supplier<Item> WOLFSBANE_FLOWER = EItems.registerItem("wolfsbane_flower");
    public static final Supplier<ItemNameBlockItem> WOLFSBANE_SEEDS = EItems.registerBlockNamed("wolfsbane_seeds", EBlocks.WOLFSBANE);
    public static final Supplier<Item> WOOD_ASH = EItems.registerItem("wood_ash");
    public static final Supplier<Item> WOOL_OF_BAT = EItems.registerItem("wool_of_bat");

    private static <T extends Item> Supplier<T> register(String name, Supplier<T> itemSupplier) {
        return CommonServices.COMMON_REGISTRY.register(BuiltInRegistries.ITEM, name, itemSupplier);
    }

    private static Supplier<Item> registerItem(String name) {
        return EItems.register(name, () -> new Item(new Item.Properties()));
    }

    private static Supplier<Item> registerItem(String name, Item.Properties properties) {
        return EItems.register(name, () -> new Item(properties));
    }

    private static Supplier<BlockItem> registerBlock(String name, Supplier<? extends Block> block) {
        return EItems.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static Supplier<BlockItem> registerBlock(String name, Supplier<? extends Block> block, Item.Properties properties) {
        return EItems.register(name, () -> new BlockItem((Block)block.get(), properties));
    }

    private static Supplier<ItemNameBlockItem> registerBlockNamed(String name, Supplier<? extends Block> block) {
        return EItems.register(name, () -> new ItemNameBlockItem((Block)block.get(), new Item.Properties()));
    }

    private static Supplier<Item> registerFood(String name, int nutrition, boolean fast) {
        FoodProperties.Builder builder = new FoodProperties.Builder().nutrition(nutrition);
        if (fast) {
            builder.fast();
        }
        return EItems.register(name, () -> new Item(new Item.Properties().food(builder.build())));
    }

    private static Supplier<Item> registerFood(String name, int nutrition, Holder<MobEffect> effect, int duration, int amplification, float chance) {
        return EItems.register(name, () -> new Item(new Item.Properties().food(new FoodProperties.Builder().nutrition(nutrition).effect(new MobEffectInstance(effect, duration, amplification), chance).build())));
    }

    private static Supplier<ChalkItem> registerChalk(String name, Supplier<? extends AbstractChalkBlock> block, int durability) {
        return EItems.register(name, () -> new ChalkItem((AbstractChalkBlock)((Object)((Object)block.get())), new Item.Properties().stacksTo(1).durability(durability)));
    }

    private static Supplier<SwordItem> registerSword(String name, Tier tier, int attackDamage, float attackSpeed) {
        return EItems.register(name, () -> new SwordItem(tier, new Item.Properties().attributes(SwordItem.createAttributes((Tier)tier, (int)attackDamage, (float)attackSpeed))));
    }

    private static Supplier<SimpleEffectBrewItem> registerBrew(String name, Supplier<Holder<MobEffect>> effect, int duration, int amplifier) {
        return EItems.register(name, () -> new SimpleEffectBrewItem(effect, duration, amplifier, new Item.Properties()));
    }

    public static boolean isToolPoppet(Item item) {
        return item == TOOL_POPPET.get() || item == TOOL_POPPET_INFUSED.get() || item == TOOL_POPPET_STURDY.get();
    }

    public static boolean isArmourPoppet(Item item) {
        return item == ARMOUR_POPPET.get() || item == ARMOUR_POPPET_INFUSED.get() || item == ARMOUR_POPPET_STURDY.get();
    }

    public static boolean isVoodooProtectionPoppet(Item item) {
        return item == VOODOO_PROTECTION_POPPET.get() || item == VOODOO_PROTECTION_POPPET_INFUSED.get() || item == VOODOO_PROTECTION_POPPET_STURDY.get();
    }

    public static void registerCompostables() {
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)WATER_ARTICHOKE_SEEDS.get()), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)WATER_ARTICHOKE.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)SNOWBELL_SEEDS.get()), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)BELLADONNA_SEEDS.get()), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)BELLADONNA_FLOWER.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)MANDRAKE_SEEDS.get()), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)MANDRAKE_ROOT.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)WOLFSBANE_SEEDS.get()), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)WOLFSBANE_FLOWER.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)GARLIC.get()), 0.45f);
    }

    public static void registerFuel(Map<Item, Integer> map) {
    }

    public static Item.Properties props() {
        return new Item.Properties();
    }

    public static Item.Properties poppetProps(int durability) {
        return EItems.props().durability(durability).stacksTo(1);
    }

    public static void load() {
    }
}

