/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.init;

import java.util.function.Supplier;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.entities.Broomstick;
import net.favouriteless.enchanted.common.entities.FamiliarCat;
import net.favouriteless.enchanted.common.entities.Mandrake;
import net.favouriteless.enchanted.common.entities.ThrowableBrew;
import net.favouriteless.enchanted.common.entities.VoodooItemEntity;
import net.favouriteless.enchanted.platform.CommonServices;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;

public class EEntityTypes {
    public static final Supplier<EntityType<Broomstick>> BROOMSTICK = EEntityTypes.register("broomstick", () -> EntityType.Builder.of(Broomstick::new, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).clientTrackingRange(10).build(Enchanted.id("broomstick").toString()));
    public static final Supplier<EntityType<FamiliarCat>> FAMILIAR_CAT = EEntityTypes.register("familiar_cat", () -> EntityType.Builder.of(FamiliarCat::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 0.7f).clientTrackingRange(8).build(Enchanted.id("familiar_cat").toString()));
    public static final Supplier<EntityType<Mandrake>> MANDRAKE = EEntityTypes.register("mandrake", () -> EntityType.Builder.of(Mandrake::new, (MobCategory)MobCategory.MONSTER).sized(0.4f, 0.7f).build(Enchanted.id("mandrake").toString()));
    public static final Supplier<EntityType<ThrowableBrew>> THROWABLE_BREW = EEntityTypes.register("throwable_brew", () -> EntityType.Builder.of(ThrowableBrew::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10).build(Enchanted.id("throwable_brew").toString()));
    public static final Supplier<EntityType<VoodooItemEntity>> VOODOO_ITEM = EEntityTypes.register("voodoo_item", () -> EntityType.Builder.of(VoodooItemEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(6).updateInterval(20).build(Enchanted.id("voodoo_item").toString()));

    private static <T extends EntityType<?>> Supplier<T> register(String name, Supplier<T> entityTypeSupplier) {
        return CommonServices.COMMON_REGISTRY.register(BuiltInRegistries.ENTITY_TYPE, name, entityTypeSupplier);
    }

    public static void load() {
    }
}

