/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.init;

import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.favouriteless.enchanted.common.blocks.DistilleryBlock;
import net.favouriteless.enchanted.common.blocks.EnchantedLog;
import net.favouriteless.enchanted.common.blocks.FumeFunnelBlock;
import net.favouriteless.enchanted.common.blocks.InfinityEggBlock;
import net.favouriteless.enchanted.common.blocks.PoppetShelfBlock;
import net.favouriteless.enchanted.common.blocks.ProtectionBarrierBlock;
import net.favouriteless.enchanted.common.blocks.SpinningWheelBlock;
import net.favouriteless.enchanted.common.blocks.WitchOvenBlock;
import net.favouriteless.enchanted.common.blocks.altar.AltarBlock;
import net.favouriteless.enchanted.common.blocks.altar.CandelabraBlock;
import net.favouriteless.enchanted.common.blocks.altar.ChaliceBlock;
import net.favouriteless.enchanted.common.blocks.cauldrons.KettleBlock;
import net.favouriteless.enchanted.common.blocks.cauldrons.WitchCauldronBlock;
import net.favouriteless.enchanted.common.blocks.chalk.ChalkCircleBlock;
import net.favouriteless.enchanted.common.blocks.chalk.GoldChalkBlock;
import net.favouriteless.enchanted.common.blocks.crops.ArtichokeBlock;
import net.favouriteless.enchanted.common.blocks.crops.BelladonnaBlock;
import net.favouriteless.enchanted.common.blocks.crops.BloodPoppyBlock;
import net.favouriteless.enchanted.common.blocks.crops.CropBlockAgeFive;
import net.favouriteless.enchanted.common.blocks.crops.EmberMossBlock;
import net.favouriteless.enchanted.common.blocks.crops.GarlicBlock;
import net.favouriteless.enchanted.common.blocks.crops.GlintWeedBlock;
import net.favouriteless.enchanted.common.blocks.crops.MandrakeBlock;
import net.favouriteless.enchanted.common.blocks.crops.SnowbellBlock;
import net.favouriteless.enchanted.common.blocks.crops.WolfsbaneBlock;
import net.favouriteless.enchanted.common.init.ETreeGrowers;
import net.favouriteless.enchanted.platform.CommonServices;
import net.favouriteless.enchanted.platform.services.CommonRegistryHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class EBlocks {
    public static final Supplier<RotatedPillarBlock> STRIPPED_ALDER_LOG = EBlocks.register("stripped_alder_log", () -> EBlocks.log(MapColor.COLOR_ORANGE, MapColor.COLOR_ORANGE));
    public static final Supplier<RotatedPillarBlock> STRIPPED_HAWTHORN_LOG = EBlocks.register("stripped_hawthorn_log", () -> EBlocks.log(MapColor.CLAY, MapColor.CLAY));
    public static final Supplier<RotatedPillarBlock> STRIPPED_ROWAN_LOG = EBlocks.register("stripped_rowan_log", () -> EBlocks.log(MapColor.WOOD, MapColor.WOOD));
    public static final Supplier<ButtonBlock> ALDER_BUTTON = EBlocks.register("alder_button", EBlocks::woodenButton);
    public static final Supplier<FenceBlock> ALDER_FENCE = EBlocks.register("alder_fence", EBlocks::woodenFence);
    public static final Supplier<FenceGateBlock> ALDER_FENCE_GATE = EBlocks.register("alder_fence_gate", EBlocks::woodenGate);
    public static final Supplier<Block> ALDER_LEAVES = EBlocks.register("alder_leaves", EBlocks::leaves);
    public static final Supplier<EnchantedLog> ALDER_LOG = EBlocks.register("alder_log", () -> EBlocks.strippableLog(MapColor.COLOR_ORANGE, MapColor.STONE, STRIPPED_ALDER_LOG));
    public static final Supplier<Block> ALDER_PLANKS = EBlocks.register("alder_planks", () -> EBlocks.block((BlockBehaviour)Blocks.OAK_PLANKS));
    public static final Supplier<PressurePlateBlock> ALDER_PRESSURE_PLATE = EBlocks.register("alder_pressure_plate", () -> EBlocks.woodenPressurePlate(MapColor.COLOR_ORANGE));
    public static final Supplier<SaplingBlock> ALDER_SAPLING = EBlocks.register("alder_sapling", () -> EBlocks.sapling(ETreeGrowers.ALDER));
    public static final Supplier<SlabBlock> ALDER_SLAB = EBlocks.register("alder_slab", () -> EBlocks.slab(Blocks.OAK_SLAB));
    public static final Supplier<StairBlock> ALDER_STAIRS = EBlocks.register("alder_stairs", () -> EBlocks.stairs(ALDER_PLANKS.get()));
    public static final Supplier<AltarBlock> ALTAR = EBlocks.register("altar", () -> new AltarBlock(EBlocks.copy((BlockBehaviour)Blocks.STONE).pushReaction(PushReaction.BLOCK).requiresCorrectToolForDrops()));
    public static final Supplier<CropBlockAgeFive> BELLADONNA = EBlocks.register("belladonna", () -> new BelladonnaBlock(EBlocks.copy((BlockBehaviour)Blocks.WHEAT)));
    public static final Supplier<BloodPoppyBlock> BLOOD_POPPY = EBlocks.register("blood_poppy", () -> new BloodPoppyBlock(EBlocks.copy((BlockBehaviour)Blocks.POPPY)));
    public static final Supplier<CandelabraBlock> CANDELABRA = EBlocks.register("candelabra", CandelabraBlock::new);
    public static final Supplier<ChaliceBlock> CHALICE = EBlocks.register("chalice", () -> new ChaliceBlock(false, BlockBehaviour.Properties.of().strength(1.0f, 6.0f).noOcclusion()));
    public static final Supplier<ChaliceBlock> CHALICE_FILLED = EBlocks.register("chalice_filled", () -> new ChaliceBlock(true, BlockBehaviour.Properties.of().strength(1.0f, 6.0f).noOcclusion()));
    public static final Supplier<DistilleryBlock> DISTILLERY = EBlocks.register("distillery", () -> new DistilleryBlock(EBlocks.copy((BlockBehaviour)Blocks.ANVIL).lightLevel(EBlocks.getLightValueLit(13)).noOcclusion()));
    public static final Supplier<EmberMossBlock> EMBER_MOSS = EBlocks.register("ember_moss", () -> new EmberMossBlock(EBlocks.copy((BlockBehaviour)Blocks.POPPY).lightLevel(a -> 6).randomTicks()));
    public static final Supplier<FumeFunnelBlock> FUME_FUNNEL = EBlocks.register("fume_funnel", () -> new FumeFunnelBlock(0.2, EBlocks.copy((BlockBehaviour)Blocks.ANVIL)));
    public static final Supplier<FumeFunnelBlock> FUME_FUNNEL_FILTERED = EBlocks.register("fume_funnel_filtered", () -> new FumeFunnelBlock(0.35, EBlocks.copy((BlockBehaviour)Blocks.ANVIL)));
    public static final Supplier<GarlicBlock> GARLIC = EBlocks.register("garlic", () -> new GarlicBlock(EBlocks.copy((BlockBehaviour)Blocks.CARROTS)));
    public static final Supplier<GlintWeedBlock> GLINT_WEED = EBlocks.register("glint_weed", () -> new GlintWeedBlock(EBlocks.copy((BlockBehaviour)Blocks.POPPY).lightLevel(a -> 14).randomTicks()));
    public static final Supplier<GoldChalkBlock> GOLDEN_CHALK = EBlocks.register("golden_chalk", GoldChalkBlock::new);
    public static final Supplier<ButtonBlock> HAWTHORN_BUTTON = EBlocks.register("hawthorn_button", EBlocks::woodenButton);
    public static final Supplier<FenceBlock> HAWTHORN_FENCE = EBlocks.register("hawthorn_fence", EBlocks::woodenFence);
    public static final Supplier<FenceGateBlock> HAWTHORN_FENCE_GATE = EBlocks.register("hawthorn_fence_gate", EBlocks::woodenGate);
    public static final Supplier<Block> HAWTHORN_LEAVES = EBlocks.register("hawthorn_leaves", EBlocks::leaves);
    public static final Supplier<EnchantedLog> HAWTHORN_LOG = EBlocks.register("hawthorn_log", () -> EBlocks.strippableLog(MapColor.CLAY, MapColor.CLAY, STRIPPED_HAWTHORN_LOG));
    public static final Supplier<Block> HAWTHORN_PLANKS = EBlocks.register("hawthorn_planks", () -> EBlocks.block((BlockBehaviour)Blocks.OAK_PLANKS));
    public static final Supplier<PressurePlateBlock> HAWTHORN_PRESSURE_PLATE = EBlocks.register("hawthorn_pressure_plate", () -> EBlocks.woodenPressurePlate(MapColor.CLAY));
    public static final Supplier<SaplingBlock> HAWTHORN_SAPLING = EBlocks.register("hawthorn_sapling", () -> EBlocks.sapling(ETreeGrowers.HAWTHORN));
    public static final Supplier<SlabBlock> HAWTHORN_SLAB = EBlocks.register("hawthorn_slab", () -> EBlocks.slab(Blocks.OAK_SLAB));
    public static final Supplier<StairBlock> HAWTHORN_STAIRS = EBlocks.register("hawthorn_stairs", () -> EBlocks.stairs(HAWTHORN_PLANKS.get()));
    public static final Supplier<InfinityEggBlock> INFINITY_EGG = EBlocks.register("infinity_egg", () -> new InfinityEggBlock(EBlocks.copy((BlockBehaviour)Blocks.DRAGON_EGG).noLootTable()));
    public static final Supplier<KettleBlock> KETTLE = EBlocks.register("kettle", () -> new KettleBlock(EBlocks.copy((BlockBehaviour)Blocks.CAULDRON).noOcclusion()));
    public static final Supplier<MandrakeBlock> MANDRAKE = EBlocks.register("mandrake", () -> new MandrakeBlock(EBlocks.copy((BlockBehaviour)Blocks.CARROTS)));
    public static final Supplier<ChalkCircleBlock> NETHER_CHALK = EBlocks.register("nether_chalk", () -> new ChalkCircleBlock(ParticleTypes.FLAME));
    public static final Supplier<ChalkCircleBlock> OTHERWHERE_CHALK = EBlocks.register("otherwhere_chalk", () -> new ChalkCircleBlock(ParticleTypes.DRAGON_BREATH));
    public static final Supplier<PoppetShelfBlock> POPPET_SHELF = EBlocks.register("poppet_shelf", () -> new PoppetShelfBlock(EBlocks.copy((BlockBehaviour)Blocks.ENCHANTING_TABLE).noOcclusion()));
    public static final Supplier<ProtectionBarrierBlock> PROTECTION_BARRIER = EBlocks.register("protection_barrier", () -> new ProtectionBarrierBlock(false, EBlocks.copy((BlockBehaviour)Blocks.BARRIER).randomTicks()));
    public static final Supplier<ProtectionBarrierBlock> PROTECTION_BARRIER_BLOCKING = EBlocks.register("protection_barrier_temporary", () -> new ProtectionBarrierBlock(true, EBlocks.copy((BlockBehaviour)Blocks.BARRIER).randomTicks()));
    public static final Supplier<ChalkCircleBlock> RITUAL_CHALK = EBlocks.register("ritual_chalk", () -> new ChalkCircleBlock(null));
    public static final Supplier<ButtonBlock> ROWAN_BUTTON = EBlocks.register("rowan_button", EBlocks::woodenButton);
    public static final Supplier<FenceBlock> ROWAN_FENCE = EBlocks.register("rowan_fence", EBlocks::woodenFence);
    public static final Supplier<FenceGateBlock> ROWAN_FENCE_GATE = EBlocks.register("rowan_fence_gate", EBlocks::woodenGate);
    public static final Supplier<Block> ROWAN_LEAVES = EBlocks.register("rowan_leaves", EBlocks::leaves);
    public static final Supplier<EnchantedLog> ROWAN_LOG = EBlocks.register("rowan_log", () -> EBlocks.strippableLog(MapColor.WOOD, MapColor.PODZOL, STRIPPED_ROWAN_LOG));
    public static final Supplier<Block> ROWAN_PLANKS = EBlocks.register("rowan_planks", () -> EBlocks.block((BlockBehaviour)Blocks.OAK_PLANKS));
    public static final Supplier<PressurePlateBlock> ROWAN_PRESSURE_PLATE = EBlocks.register("rowan_pressure_plate", () -> EBlocks.woodenPressurePlate(MapColor.WOOD));
    public static final Supplier<SaplingBlock> ROWAN_SAPLING = EBlocks.register("rowan_sapling", () -> EBlocks.sapling(ETreeGrowers.ROWAN));
    public static final Supplier<SlabBlock> ROWAN_SLAB = EBlocks.register("rowan_slab", () -> EBlocks.slab(Blocks.OAK_SLAB));
    public static final Supplier<StairBlock> ROWAN_STAIRS = EBlocks.register("rowan_stairs", () -> EBlocks.stairs(ROWAN_PLANKS.get()));
    public static final Supplier<SnowbellBlock> SNOWBELL = EBlocks.register("snowbell", () -> new SnowbellBlock(EBlocks.copy((BlockBehaviour)Blocks.WHEAT)));
    public static final Supplier<VineBlock> SPANISH_MOSS = EBlocks.register("spanish_moss", () -> new VineBlock(EBlocks.copy((BlockBehaviour)Blocks.VINE)));
    public static final Supplier<SpinningWheelBlock> SPINNING_WHEEL = EBlocks.register("spinning_wheel", () -> new SpinningWheelBlock(EBlocks.copy((BlockBehaviour)Blocks.OAK_PLANKS).noOcclusion()));
    public static final Supplier<ArtichokeBlock> WATER_ARTICHOKE = EBlocks.register("water_artichoke", () -> new ArtichokeBlock(EBlocks.copy((BlockBehaviour)Blocks.WHEAT).sound(SoundType.LILY_PAD)));
    public static final Supplier<HayBlock> WICKER_BUNDLE = EBlocks.register("wicker_bundle", () -> new HayBlock(EBlocks.copy((BlockBehaviour)Blocks.HAY_BLOCK)));
    public static final Supplier<WitchCauldronBlock> WITCH_CAULDRON = EBlocks.register("witch_cauldron", () -> new WitchCauldronBlock(EBlocks.copy((BlockBehaviour)Blocks.CAULDRON).noOcclusion()));
    public static final Supplier<WitchOvenBlock> WITCH_OVEN = EBlocks.register("witch_oven", () -> new WitchOvenBlock(EBlocks.copy((BlockBehaviour)Blocks.ANVIL)));
    public static final Supplier<WolfsbaneBlock> WOLFSBANE = EBlocks.register("wolfsbane", () -> new WolfsbaneBlock(EBlocks.copy((BlockBehaviour)Blocks.WHEAT)));

    public static void registerFlammables() {
        CommonRegistryHelper registry = CommonServices.COMMON_REGISTRY;
        registry.setFlammable((Block)ROWAN_LOG.get(), 5, 5);
        registry.setFlammable(ROWAN_PLANKS.get(), 5, 20);
        registry.setFlammable((Block)ROWAN_STAIRS.get(), 5, 20);
        registry.setFlammable((Block)ROWAN_SLAB.get(), 5, 20);
        registry.setFlammable(ROWAN_LEAVES.get(), 30, 60);
        registry.setFlammable((Block)ALDER_LOG.get(), 5, 5);
        registry.setFlammable(ALDER_PLANKS.get(), 5, 20);
        registry.setFlammable((Block)ALDER_STAIRS.get(), 5, 20);
        registry.setFlammable((Block)ALDER_SLAB.get(), 5, 20);
        registry.setFlammable(ALDER_LEAVES.get(), 30, 60);
        registry.setFlammable((Block)HAWTHORN_LOG.get(), 5, 5);
        registry.setFlammable(HAWTHORN_PLANKS.get(), 5, 20);
        registry.setFlammable((Block)HAWTHORN_STAIRS.get(), 5, 20);
        registry.setFlammable((Block)HAWTHORN_SLAB.get(), 5, 20);
        registry.setFlammable(HAWTHORN_LEAVES.get(), 30, 60);
        registry.setFlammable((Block)STRIPPED_ALDER_LOG.get(), 5, 5);
        registry.setFlammable((Block)STRIPPED_HAWTHORN_LOG.get(), 5, 5);
        registry.setFlammable((Block)STRIPPED_ROWAN_LOG.get(), 5, 5);
        registry.setFlammable((Block)ALDER_FENCE.get(), 5, 20);
        registry.setFlammable((Block)ALDER_FENCE_GATE.get(), 5, 20);
        registry.setFlammable((Block)HAWTHORN_FENCE.get(), 5, 20);
        registry.setFlammable((Block)HAWTHORN_FENCE_GATE.get(), 5, 20);
        registry.setFlammable((Block)ROWAN_FENCE.get(), 5, 20);
        registry.setFlammable((Block)ROWAN_FENCE_GATE.get(), 5, 20);
    }

    public static <T extends Block> Supplier<T> register(String name, Supplier<T> blockSupplier) {
        return CommonServices.COMMON_REGISTRY.register(BuiltInRegistries.BLOCK, name, blockSupplier);
    }

    public static ToIntFunction<BlockState> getLightValueLit(int lightValue) {
        return state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? lightValue : 0;
    }

    private static RotatedPillarBlock log(MapColor topColor, MapColor barkColor) {
        return new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG).mapColor(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? topColor : barkColor));
    }

    private static EnchantedLog strippableLog(MapColor topColor, MapColor barkColor, Supplier<RotatedPillarBlock> stripped) {
        return new EnchantedLog(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG).mapColor(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? topColor : barkColor), stripped);
    }

    private static ButtonBlock woodenButton() {
        return new ButtonBlock(BlockSetType.OAK, 30, BlockBehaviour.Properties.of().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY));
    }

    private static FenceBlock woodenFence() {
        return new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE));
    }

    private static FenceGateBlock woodenGate() {
        return new FenceGateBlock(WoodType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE));
    }

    private static PressurePlateBlock woodenPressurePlate(MapColor mapColor) {
        return new PressurePlateBlock(BlockSetType.OAK, BlockBehaviour.Properties.of().mapColor(mapColor).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY));
    }

    private static LeavesBlock leaves() {
        return new LeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES));
    }

    private static Block block(BlockBehaviour.Properties properties) {
        return new Block(properties);
    }

    private static Block block(BlockBehaviour block) {
        return new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block));
    }

    private static Block block(Supplier<BlockBehaviour> block) {
        return EBlocks.block(block.get());
    }

    public static StairBlock stairs(Block base) {
        return new StairBlock(base.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)base));
    }

    public static SlabBlock slab(Block base) {
        return new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)base));
    }

    public static SaplingBlock sapling(TreeGrower treeGrower) {
        return new SaplingBlock(treeGrower, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING));
    }

    public static BlockBehaviour.Properties copy(BlockBehaviour block) {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block);
    }

    public static void load() {
    }
}

