/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.entities;

import net.favouriteless.enchanted.common.poppet.PoppetUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class VoodooItemEntity
extends ItemEntity {
    private int underWaterTicks;
    private int health;

    public VoodooItemEntity(EntityType<? extends ItemEntity> type, Level level) {
        super(type, level);
    }

    public boolean fireImmune() {
        return true;
    }

    public void setItem(ItemStack stack) {
        if (stack.isDamageableItem()) {
            this.health = stack.getMaxDamage() - stack.getDamageValue();
        }
        super.setItem(stack);
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ItemStack item;
            ServerPlayer target;
            ServerLevel level2 = (ServerLevel)level;
            if (PoppetUtils.isBound(this.getItem()) && (target = PoppetUtils.getBoundPlayer(item = this.getItem(), level2)) != null) {
                this.underWaterTicks = this.isInWaterOrBubble() ? ++this.underWaterTicks : 0;
                if (this.underWaterTicks > 20 && PoppetUtils.tryVoodooPlayer(target, (ServerPlayer)this.getOwner(), item) && target.hurt(level2.damageSources().drown(), 1.0f)) {
                    this.hurt(1);
                } else if (this.isInLava() && PoppetUtils.tryVoodooPlayer(target, (ServerPlayer)this.getOwner(), item) && target.hurt(level2.damageSources().lava(), 4.0f)) {
                    target.igniteForSeconds(15.0f);
                    this.hurt(4);
                } else if (level2.getBlockState(this.blockPosition()).is(Blocks.FIRE) && PoppetUtils.tryVoodooPlayer(target, (ServerPlayer)this.getOwner(), item) && target.hurt(level2.damageSources().inFire(), 1.0f)) {
                    if (target.getRemainingFireTicks() < 0) {
                        target.igniteForSeconds(8.0f);
                    }
                    target.setRemainingFireTicks(target.getRemainingFireTicks() + 1);
                } else if (level2.getBlockState(this.blockPosition()).is(Blocks.SOUL_FIRE) && PoppetUtils.tryVoodooPlayer(target, (ServerPlayer)this.getOwner(), item) && target.hurt(level2.damageSources().inFire(), 2.0f)) {
                    if (target.getRemainingFireTicks() < 0) {
                        target.igniteForSeconds(8.0f);
                    }
                    target.setRemainingFireTicks(target.getRemainingFireTicks() + 1);
                }
            }
        }
    }

    public void hurt(int amount) {
        ItemStack item = this.getItem();
        if (this.level().isClientSide) {
            return;
        }
        this.health -= amount;
        item.setDamageValue(item.getMaxDamage() - this.health);
        if (this.health <= 0) {
            this.getItem().onDestroyed((ItemEntity)this);
            this.discard();
        }
    }
}

