/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.entities;

import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.common.items.brews.ThrowableBrewItem;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class ThrowableBrew
extends ThrowableItemProjectile {
    public ThrowableBrew(EntityType<? extends ThrowableBrew> type, Level level) {
        super(type, level);
    }

    protected Item getDefaultItem() {
        return EItems.BREW_OF_LOVE.get();
    }

    public double getDefaultGravity() {
        return 0.05;
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide) {
            ItemStack itemstack = this.getItem();
            Item item = itemstack.getItem();
            if (item instanceof ThrowableBrewItem) {
                ThrowableBrewItem item2 = (ThrowableBrewItem)item;
                item2.applyEffect(this.getOwner(), this.level(), result.getLocation());
                this.level().levelEvent(2002, this.blockPosition(), item2.getColour());
            }
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (!this.level().isClientSide) {
            ItemStack itemstack = this.getItem();
            Item item = itemstack.getItem();
            if (item instanceof ThrowableBrewItem) {
                ThrowableBrewItem item2 = (ThrowableBrewItem)item;
                item2.applyEffect(this.getOwner(), this.level(), result.getLocation());
                this.level().levelEvent(2002, this.blockPosition(), item2.getColour());
            }
            this.discard();
        }
    }
}

