/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.entities;

import java.util.List;
import net.favouriteless.enchanted.common.init.EDamageTypes;
import net.favouriteless.enchanted.common.init.EItems;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Mandrake
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache animationCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Mandrake(EntityType<? extends Monster> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, 1.0).build();
    }

    protected void registerGoals() {
        super.registerGoals();
        WaterAvoidingRandomStrollGoal randomWalkingGoal = new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 1.0f);
        randomWalkingGoal.setInterval(1);
        this.goalSelector.addGoal(0, (Goal)new MandrakeAttackGoal(this));
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)randomWalkingGoal);
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.GHAST_DEATH;
    }

    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.GENERIC_SMALL_FALL, SoundEvents.GENERIC_BIG_FALL);
    }

    public boolean shouldDropExperience() {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(DefaultAnimations.genericWalkController((GeoAnimatable)this));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationCache;
    }

    protected class MandrakeAttackGoal
    extends Goal {
        protected final Mandrake mob;
        protected int ticksUntilNextAttack;

        public MandrakeAttackGoal(Mandrake entity) {
            this.mob = entity;
            this.ticksUntilNextAttack = 0;
        }

        public boolean canUse() {
            return true;
        }

        public void stop() {
            this.ticksUntilNextAttack = 30;
        }

        public void tick() {
            if (--this.ticksUntilNextAttack <= 0) {
                List entitiesInRange = this.mob.level().getEntitiesOfClass(LivingEntity.class, new AABB(this.mob.position().x - 8.0, this.mob.position().y - 8.0, this.mob.position().z - 8.0, this.mob.position().x + 8.0, this.mob.position().y + 8.0, this.mob.position().z + 8.0), entity -> !(entity instanceof Mandrake));
                for (LivingEntity entity2 : entitiesInRange) {
                    Player player;
                    if (entity2 instanceof Player && (player = (Player)entity2).isCreative() || entity2.getItemBySlot(EquipmentSlot.HEAD).getItem() == EItems.EARMUFFS.get()) continue;
                    entity2.hurt(EDamageTypes.source(Mandrake.this.level(), EDamageTypes.SOUND, (Entity)this.mob), 1.0f);
                    entity2.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 1));
                }
                this.mob.level().playSound(null, this.mob.getX(), this.mob.getY(), this.mob.getZ(), SoundEvents.GHAST_HURT, SoundSource.HOSTILE, 10.0f, 0.85f + Mandrake.this.random.nextFloat() * 0.1f);
                this.ticksUntilNextAttack = 30;
            }
        }
    }
}

