/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.entities;

import net.favouriteless.enchanted.api.familiars.FamiliarHelper;
import net.favouriteless.enchanted.api.familiars.FamiliarSavedData;
import net.favouriteless.enchanted.api.familiars.IFamiliarEntry;
import net.favouriteless.enchanted.common.Enchanted;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class FamiliarCat
extends Cat {
    public FamiliarCat(EntityType<? extends Cat> type, Level level) {
        super(type, level);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (player.isCrouching() && hand == InteractionHand.MAIN_HAND && !this.level().isClientSide && player.getUUID().equals(this.getOwnerUUID())) {
            FamiliarHelper.dismiss((TamableAnimal)this);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    public void tick() {
        IFamiliarEntry entry;
        super.tick();
        if (!(this.level().isClientSide || (entry = FamiliarSavedData.get(this.level()).getEntry(this.getOwnerUUID())) != null && this.getUUID().equals(entry.getUUID()))) {
            this.discard();
            Enchanted.LOG.info(String.format("Found familiar with non-matching UUID for %s, discarding.", this.getOwnerUUID()));
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        FamiliarSavedData data;
        IFamiliarEntry entry;
        super.addAdditionalSaveData(nbt);
        if (!this.level().isClientSide && (entry = (data = FamiliarSavedData.get(this.level())).getEntry(this.getOwnerUUID())) != null) {
            entry.setNbt(nbt);
            data.setDirty();
        }
    }

    public void die(DamageSource cause) {
        super.die(cause);
        if (!this.level().isClientSide) {
            FamiliarHelper.dismiss((TamableAnimal)this);
        }
    }

    public static AttributeSupplier createCatAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.ARMOR, 5.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 3.0).build();
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypeTags.IS_FIRE) || source.is(DamageTypeTags.IS_FALL) || source.is(DamageTypeTags.IS_DROWNING) || super.isInvulnerableTo(source);
    }
}

