/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.entities;

import java.util.List;
import net.favouriteless.enchanted.client.client_handlers.entities.BroomstickEntityClientHandler;
import net.favouriteless.enchanted.common.init.EItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Broomstick
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.defineId(Broomstick.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.defineId(Broomstick.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.defineId(Broomstick.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final double ACCELERATION = 0.02;
    public static final double MAX_SPEED = 1.0;
    public static final double MAX_TILT = 20.0;
    public int inputAcceleration = 0;
    public int inputClimb = 0;
    public int inputTurn = 0;
    private float deltaRotX = 0.0f;
    private float deltaRotY = 0.0f;
    private int lerpSteps = 0;
    private double lerpX = 0.0;
    private double lerpY = 0.0;
    private double lerpZ = 0.0;
    private double lerpXRot = 0.0;
    private double lerpYRot = 0.0;

    public Broomstick(EntityType<Broomstick> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ID_HURT, (Object)0);
        builder.define(DATA_ID_HURTDIR, (Object)1);
        builder.define(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public void tick() {
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        super.tick();
        this.tickLerp();
        if (this.isControlledByLocalInstance()) {
            if (this.level().isClientSide) {
                BroomstickEntityClientHandler.controlBroom(this);
                this.handleRotationTick();
                this.handleMovementTick();
            } else {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.75));
                if (this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(0.0, 1.0, 0.0)).isEmpty()) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.01, 0.0));
                }
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
        } else {
            this.setDeltaMovement(Vec3.ZERO);
        }
    }

    protected void handleMovementTick() {
        Vec3 velocity = this.getDeltaMovement();
        Vec3 forward = Vec3.directionFromRotation((float)0.0f, (float)this.getYRot());
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        Vec3 left = up.cross(forward);
        double acceleration = (double)this.inputAcceleration * 0.02;
        velocity = forward.scale(velocity.dot(forward) * (this.inputAcceleration == 0 ? 0.85 : 1.0) + acceleration).add(up.scale(velocity.dot(up) * (this.inputClimb == 0 ? 0.85 : 1.0))).add(left.scale(velocity.dot(left) * 0.85));
        velocity = velocity.add(0.0, (double)this.inputClimb * 0.02, 0.0);
        double speed = Math.max(Math.min(velocity.length(), 1.0), 0.0);
        this.setDeltaMovement(velocity.normalize().scale(speed));
    }

    protected void handleRotationTick() {
        LivingEntity controller = this.getControllingPassenger();
        this.deltaRotY += (float)this.inputTurn;
        this.deltaRotX += (float)(this.inputClimb * -this.inputAcceleration);
        if (this.inputClimb == 0 || this.inputAcceleration == 0) {
            if (Math.abs(this.getXRot()) < Math.abs(this.deltaRotX)) {
                this.deltaRotX = -this.getXRot();
            } else if (this.getXRot() > 0.0f) {
                if (this.deltaRotX > 0.0f) {
                    this.deltaRotX = 0.0f;
                }
                this.deltaRotX -= 1.0f;
            } else if (this.getXRot() < 0.0f) {
                if (this.deltaRotX < 0.0f) {
                    this.deltaRotX = 0.0f;
                }
                this.deltaRotX += 1.0f;
            }
        }
        this.setYRot(this.getYRot() + this.deltaRotY);
        controller.setYRot(controller.getYRot() + this.deltaRotY);
        this.setXRot((float)Mth.clamp((double)(this.getXRot() + this.deltaRotX), (double)-20.0, (double)20.0));
        this.deltaRotX *= 0.8f;
        this.deltaRotY *= 0.8f;
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        return new Vec3(this.getX(), this.getBoundingBox().maxY + 0.05, this.getZ());
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    protected void playSwimSound(float pVolume) {
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    protected void tickLerp() {
        if (this.isControlledByLocalInstance()) {
            this.lerpSteps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.lerpSteps > 0) {
            this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
            --this.lerpSteps;
        }
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int steps) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yaw;
        this.lerpXRot = pitch;
        this.lerpSteps = steps;
    }

    public double getEyeY() {
        return 0.7;
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        return new Vec3(0.0, this.getEyeY(), 0.0);
    }

    public boolean isPickable() {
        return true;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (player.isSecondaryUseActive()) {
            return InteractionResult.SUCCESS;
        }
        if (!this.level().isClientSide) {
            return player.startRiding((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean isPushable() {
        return true;
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag nbt) {
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag nbt) {
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public void positionRider(@NotNull Entity passenger, Entity.MoveFunction moveFunction) {
        super.positionRider(passenger, moveFunction);
        this.clampRotation(passenger);
    }

    public boolean isControlledByLocalInstance() {
        LivingEntity entity = this.getControllingPassenger();
        if (entity instanceof Player) {
            return ((Player)entity).isLocalPlayer();
        }
        return !this.level().isClientSide;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        LivingEntity le;
        List list = this.getPassengers();
        if (list.isEmpty()) {
            return null;
        }
        Object e = list.getFirst();
        return e instanceof LivingEntity ? (le = (LivingEntity)e) : null;
    }

    protected boolean canAddPassenger(@NotNull Entity passenger) {
        return this.getPassengers().isEmpty();
    }

    public void onPassengerTurned(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    protected void clampRotation(Entity entity) {
        entity.setYBodyRot(this.getYRot());
        float f = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
        float f1 = Mth.clamp((float)f, (float)-105.0f, (float)105.0f);
        entity.yRotO += f1 - f;
        entity.setYRot(entity.getYRot() + f1 - f);
        entity.setYHeadRot(entity.getYRot());
    }

    public void push(@NotNull Entity entity) {
        if (entity instanceof Broomstick) {
            if (entity.getBoundingBox().minY < this.getBoundingBox().maxY) {
                super.push(entity);
            }
        } else if (entity.getBoundingBox().minY <= this.getBoundingBox().minY) {
            super.push(entity);
        }
    }

    public boolean hurt(@NotNull DamageSource source, float pAmount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (!this.level().isClientSide && !this.isRemoved()) {
            boolean isSurvivalPlayer;
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.setDamage(this.getDamage() + pAmount * 10.0f);
            this.markHurt();
            boolean bl = isSurvivalPlayer = source.getEntity() instanceof Player && ((Player)source.getEntity()).getAbilities().instabuild;
            if (isSurvivalPlayer || this.getDamage() > 40.0f) {
                if (!isSurvivalPlayer && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                    this.spawnAtLocation((ItemLike)EItems.ENCHANTED_BROOMSTICK.get());
                }
                this.discard();
            }
            return true;
        }
        return true;
    }

    public void setHurtDir(int pForwardDirection) {
        this.entityData.set(DATA_ID_HURTDIR, (Object)pForwardDirection);
    }

    public int getHurtDir() {
        return (Integer)this.entityData.get(DATA_ID_HURTDIR);
    }

    public void setHurtTime(int pTimeSinceHit) {
        this.entityData.set(DATA_ID_HURT, (Object)pTimeSinceHit);
    }

    public int getHurtTime() {
        return (Integer)this.entityData.get(DATA_ID_HURT);
    }

    public void setDamage(float pDamageTaken) {
        this.entityData.set(DATA_ID_DAMAGE, (Object)Float.valueOf(pDamageTaken));
    }

    public float getDamage() {
        return ((Float)this.entityData.get(DATA_ID_DAMAGE)).floatValue();
    }

    public void animateHurt(float yaw) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    public void setInputs(boolean forward, boolean backward, boolean left, boolean right, boolean up, boolean down) {
        this.inputAcceleration = 0;
        if (forward) {
            ++this.inputAcceleration;
        }
        if (backward) {
            --this.inputAcceleration;
        }
        this.inputTurn = 0;
        if (left) {
            --this.inputTurn;
        }
        if (right) {
            ++this.inputTurn;
        }
        this.inputClimb = 0;
        if (up) {
            ++this.inputClimb;
        }
        if (down) {
            --this.inputClimb;
        }
    }
}

