/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.curses;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.favouriteless.enchanted.api.curses.Curse;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.curses.CurseMisfortune;
import net.favouriteless.enchanted.common.curses.CurseOverheating;
import net.favouriteless.enchanted.common.curses.CurseSinking;
import net.favouriteless.enchanted.common.curses.CurseType;
import net.minecraft.resources.ResourceLocation;

public class CurseTypes {
    private static final Map<ResourceLocation, CurseType<?>> CURSE_TYPES = new HashMap();
    public static final CurseType<CurseMisfortune> MISFORTUNE = CurseTypes.register("misfortune", CurseMisfortune::new);
    public static final CurseType<CurseSinking> SINKING = CurseTypes.register("sinking", CurseSinking::new);
    public static final CurseType<CurseOverheating> OVERHEATING = CurseTypes.register("overheating", CurseOverheating::new);

    public static <T extends Curse> CurseType<T> register(ResourceLocation id, Supplier<T> curseSupplier) {
        CurseType<T> riteType = new CurseType<T>(id, curseSupplier);
        CURSE_TYPES.put(id, riteType);
        return riteType;
    }

    private static <T extends Curse> CurseType<T> register(String id, Supplier<T> curseSupplier) {
        return CurseTypes.register(Enchanted.id(id), curseSupplier);
    }

    public static CurseType<?> get(ResourceLocation id) {
        return CURSE_TYPES.get(id);
    }

    public static Curse create(ResourceLocation id) {
        CurseType<?> type = CurseTypes.get(id);
        return type != null ? (Curse)type.create() : null;
    }
}

