/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.curses;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.favouriteless.enchanted.api.curses.Curse;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.curses.CurseTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;

public class CurseSavedData
extends SavedData {
    private static final String NAME = Enchanted.savedDataName("curses");
    private final Map<UUID, List<Curse>> entries = new HashMap<UUID, List<Curse>>();

    public static CurseSavedData get(ServerLevel level) {
        return (CurseSavedData)level.getServer().overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(CurseSavedData::new, CurseSavedData::load, null), NAME);
    }

    public List<Curse> get(ServerPlayer player) {
        return this.get(player.getUUID());
    }

    public List<Curse> get(UUID uuid) {
        return this.entries.computeIfAbsent(uuid, k -> new ArrayList());
    }

    private static CurseSavedData load(CompoundTag nbt, HolderLookup.Provider registries) {
        CurseSavedData data = new CurseSavedData();
        for (String key : nbt.getAllKeys()) {
            UUID target = UUID.fromString(key);
            ArrayList<Curse> curses = new ArrayList<Curse>();
            for (Tag t : nbt.getList(key, 10)) {
                CompoundTag tag = (CompoundTag)t;
                Curse curse = CurseTypes.create(ResourceLocation.parse((String)tag.getString("type")));
                if (curse == null) {
                    Enchanted.LOG.info("Found saved Curse with invalid type, skipping.");
                    continue;
                }
                curse.load(tag);
                curses.add(curse);
            }
            data.entries.put(target, curses);
        }
        return data;
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registries) {
        for (UUID uuid : this.entries.keySet()) {
            List<Curse> curses = this.entries.get(uuid);
            if (curses.isEmpty()) continue;
            ListTag list = new ListTag();
            for (Curse curse : curses) {
                CompoundTag curseTag = new CompoundTag();
                curse.save(curseTag);
                list.add((Object)curseTag);
            }
            nbt.put(uuid.toString(), (Tag)list);
        }
        return nbt;
    }
}

