/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.curses;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.favouriteless.enchanted.api.curses.Curse;
import net.favouriteless.enchanted.api.curses.CurseManager;
import net.favouriteless.enchanted.common.curses.CurseSavedData;
import net.favouriteless.enchanted.common.curses.CurseType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class CurseManagerImpl
implements CurseManager {
    public static final CurseManagerImpl INSTANCE = new CurseManagerImpl();
    public static final int MAX_STRENGTH = 2;
    private final Map<UUID, List<Curse>> activeCurses = new HashMap<UUID, List<Curse>>();

    private CurseManagerImpl() {
    }

    @Override
    public void createCurse(CurseType<?> type, ServerLevel level, UUID target, int strength) {
        Object curse = type.create();
        ((Curse)curse).setTargetUUID(target);
        ((Curse)curse).strength = strength;
        this.addCurse(level, (Curse)curse);
    }

    @Override
    public List<Curse> getCursesFor(ServerPlayer player) {
        CurseSavedData data = CurseSavedData.get(player.serverLevel());
        return data.get(player);
    }

    @Override
    public void removeCurse(ServerLevel level, Curse curse) {
        CurseSavedData data = CurseSavedData.get(level);
        data.get(curse.getTargetUUID()).remove(curse);
        data.setDirty();
        curse.remove(level);
    }

    private void addCurse(ServerLevel level, Curse curse) {
        UUID target;
        CurseSavedData data = CurseSavedData.get(level);
        List<Curse> curses = data.get(target = curse.getTargetUUID());
        Optional<Curse> optional = curses.stream().filter(c -> c.type == curse.type).findFirst();
        if (optional.isPresent()) {
            Curse existing = optional.get();
            if (curse.strength < existing.strength) {
                return;
            }
            curses.remove(existing);
        }
        curses.add(curse);
        data.setDirty();
        if (level.getServer().getPlayerList().getPlayer(target) != null) {
            this.activeCurses.put(target, curses);
        }
    }

    public void tick(ServerLevel level) {
        if (level.dimension() != Level.OVERWORLD) {
            return;
        }
        for (List<Curse> curses : this.activeCurses.values()) {
            curses.forEach(c -> c.tick(level));
        }
    }

    public void playerLoggedIn(ServerPlayer player) {
        CurseSavedData data = CurseSavedData.get(player.serverLevel());
        UUID uuid = player.getUUID();
        this.activeCurses.put(uuid, data.get(uuid));
    }

    public void playerLoggedOut(ServerPlayer player) {
        this.activeCurses.remove(player.getUUID());
    }
}

