/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites.factory;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.favouriteless.enchanted.api.circle_magic.RiteFactory;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.circle_magic.RiteTargetingType;
import net.favouriteless.enchanted.common.circle_magic.rites.ProtectionEntityRite;
import net.favouriteless.enchanted.common.circle_magic.rites.ProtectionRite;
import net.favouriteless.enchanted.common.circle_magic.rites.ProtectionWaystoneRite;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.minecraft.resources.ResourceLocation;

public record ProtectionFactory(RiteTargetingType target, int radius, int duration, boolean blocksPlayers) implements RiteFactory
{
    public static final ResourceLocation ID = Enchanted.id("protection");
    public static final MapCodec<ProtectionFactory> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RiteTargetingType.CODEC.optionalFieldOf("target", (Object)RiteTargetingType.DEFAULT).forGetter(f -> f.target), (App)Codec.INT.fieldOf("radius").forGetter(f -> f.radius), (App)Codec.INT.optionalFieldOf("duration", (Object)Integer.MAX_VALUE).forGetter(f -> f.duration), (App)Codec.BOOL.optionalFieldOf("blocks_players", (Object)false).forGetter(f -> f.blocksPlayers)).apply((Applicative)instance, ProtectionFactory::new));

    @Override
    public Rite create(Rite.BaseRiteParams baseParams, Rite.RiteParams params) {
        return switch (this.target) {
            default -> throw new MatchException(null, null);
            case RiteTargetingType.DEFAULT -> new ProtectionRite(baseParams, params, this.radius, this.duration, this.blocksPlayers);
            case RiteTargetingType.LOCATION -> new ProtectionWaystoneRite(baseParams, params, this.radius, this.duration, this.blocksPlayers);
            case RiteTargetingType.ENTITY -> new ProtectionEntityRite(baseParams, params, this.radius, this.duration, this.blocksPlayers);
        };
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }
}

