/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import net.favouriteless.enchanted.common.circle_magic.rites.LocationTargetRite;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public abstract class TransposeEntityRite
extends LocationTargetRite {
    public TransposeEntityRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params) {
        super(baseParams, params);
    }

    @Override
    protected boolean onStart(Rite.RiteParams params) {
        super.onStart(params);
        Entity transposee = this.getTransposee(params);
        if (transposee == null) {
            return this.cancel();
        }
        this.portalParticles((ServerLevel)transposee.level(), transposee.blockPosition());
        this.portalParticles(this.targetLevel, this.targetPos);
        transposee.level().playSound(null, transposee.blockPosition(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.MASTER, 1.0f, 1.0f);
        Vec3 destination = this.targetPos.getCenter().add(0.0, 0.01, 0.0);
        if (this.targetLevel != transposee.level()) {
            transposee.changeDimension(new DimensionTransition(this.targetLevel, destination, Vec3.ZERO, 0.0f, 0.0f, DimensionTransition.DO_NOTHING));
        } else {
            transposee.teleportTo(destination.x, destination.y, destination.z);
        }
        this.level.playSound(null, this.targetPos, SoundEvents.ENDERMAN_TELEPORT, SoundSource.MASTER, 1.0f, 1.0f);
        return false;
    }

    protected abstract Entity getTransposee(Rite.RiteParams var1);

    protected void portalParticles(ServerLevel level, BlockPos pos) {
        for (int i = 0; i < 25; ++i) {
            double dx = (double)pos.getX() + Math.random() * 1.5;
            double dy = (double)pos.getY() + Math.random() * 2.0;
            double dz = (double)pos.getZ() + Math.random() * 1.5;
            level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, dx, dy, dz, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

