/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import net.favouriteless.enchanted.api.Vec2i;
import net.favouriteless.enchanted.client.particles.types.DoubleOptions;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.init.EParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class TransposeBlocksRite
extends Rite {
    private final TagKey<Block> tag;
    private final ItemStack tool;

    public TransposeBlocksRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params, TagKey<Block> tag, ItemStack tool) {
        super(baseParams, params);
        this.tag = tag;
        this.tool = tool;
    }

    @Override
    protected boolean onTick(Rite.RiteParams params) {
        Vec2i offset = this.type.getInteriorPoints().get(params.ticks());
        for (int i = 0; i < this.pos.getY() - this.level.getMinBuildHeight(); ++i) {
            BlockPos pos = this.pos.offset(offset.x(), -i, offset.y());
            BlockState state = this.level.getBlockState(pos);
            if (!state.is(this.tag)) continue;
            this.level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            this.level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of(null, (BlockState)state));
            Block.dropResources((BlockState)state, (Level)this.level, (BlockPos)this.pos, null, null, (ItemStack)this.tool);
            this.level.playSound(null, this.pos, SoundEvents.COPPER_BREAK, SoundSource.MASTER, 1.0f, 1.0f);
            this.randomParticles((ParticleOptions)ParticleTypes.WITCH);
        }
        if (params.ticks() % 20 == 0) {
            this.level.sendParticles((ParticleOptions)new DoubleOptions(EParticleTypes.TRANSPOSITION_IRON_SEED.get(), this.type.getRadius()), (double)this.pos.getX() + 0.5, (double)this.pos.getY() - 0.1, (double)this.pos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        return params.ticks() < this.type.getInteriorPoints().size() - 1;
    }
}

