/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import net.favouriteless.enchanted.api.familiars.FamiliarSavedData;
import net.favouriteless.enchanted.api.familiars.IFamiliarEntry;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public class SummonFamiliarRite
extends Rite {
    public SummonFamiliarRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params) {
        super(baseParams, params);
    }

    @Override
    protected boolean onStart(Rite.RiteParams params) {
        IFamiliarEntry entry = FamiliarSavedData.get((Level)this.getLevel()).getEntry(params.caster);
        if (entry == null) {
            return this.cancel();
        }
        Vec3 center = this.pos.getBottomCenter().add(0.0, 0.01, 0.0);
        Entity target = this.findEntity(entry.getUUID());
        if (target == null) {
            target = entry.getType().getTypeOut().create((Level)this.level);
            target.load(entry.getNbt());
            target.setPos(center);
            this.level.addFreshEntity(target);
            ((TamableAnimal)target).setPersistenceRequired();
            entry.setUUID(target.getUUID());
        }
        if (target.level() != this.level) {
            target.changeDimension(new DimensionTransition(this.level, center, Vec3.ZERO, 0.0f, 0.0f, DimensionTransition.DO_NOTHING));
        } else {
            target.teleportTo(center.x, center.y, center.z);
        }
        entry.setDismissed(false);
        this.level.playSound(null, center.x, center.y, center.z, SoundEvents.ENDERMAN_TELEPORT, SoundSource.NEUTRAL, 1.0f, 1.0f);
        this.randomParticles((ParticleOptions)ParticleTypes.PORTAL);
        return false;
    }
}

