/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import net.favouriteless.enchanted.common.circle_magic.rites.LocationTargetRite;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.init.EParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;

public class SkyWrathRite
extends LocationTargetRite {
    public static final int START_RAINING = 120;
    public static final int EXPLODE = 180;
    public static final double LIGHTNING_RADIUS = 5.0;

    public SkyWrathRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params) {
        super(baseParams, params);
    }

    @Override
    protected boolean onStart(Rite.RiteParams params) {
        super.onStart(params);
        this.targetLevel.sendParticles((ParticleOptions)EParticleTypes.SKY_WRATH_SEED.get(), (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 2.0, (double)this.pos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        return true;
    }

    @Override
    protected boolean onTick(Rite.RiteParams params) {
        if (params.ticks() == 120) {
            this.level.setWeatherParameters(0, 6000, true, true);
        } else if (params.ticks() > 180) {
            this.findTargetLocation(params);
            this.spawnLightning(this.targetLevel, (double)this.targetPos.getX() + 0.5, this.targetPos.getY(), (double)this.targetPos.getZ() + 0.5);
            return false;
        }
        return true;
    }

    protected void spawnLightning(ServerLevel level, double x, double y, double z) {
        for (int a = 0; a < 360; a += 60) {
            double angle = Math.toRadians(a);
            double cx = x + Math.sin(angle) * 5.0;
            double cz = z + Math.cos(angle) * 5.0;
            LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)level);
            bolt.setPos(cx, y, cz);
            level.addFreshEntity((Entity)bolt);
        }
    }
}

