/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import java.util.List;
import net.favouriteless.enchanted.client.particles.types.ColouredCircleOptions;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.init.EParticleTypes;
import net.favouriteless.enchanted.common.init.ETags;
import net.favouriteless.enchanted.common.util.EntityUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SanctityRite
extends Rite {
    public static final float RADIUS = 3.0f;
    public static final float RADIUS_SQR = 9.0f;
    public static final double REPULSE_FACTOR = 3.0;

    public SanctityRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params) {
        super(baseParams, params);
    }

    @Override
    protected boolean onStart(Rite.RiteParams params) {
        this.level.playSound(null, this.pos, SoundEvents.ZOMBIE_VILLAGER_CURE, SoundSource.MASTER, 0.5f, 1.0f);
        return true;
    }

    @Override
    protected boolean onTick(Rite.RiteParams params) {
        Vec3 center = this.pos.getBottomCenter();
        List entities = this.level.getEntities((Entity)null, new AABB(center.subtract(5.0, 0.0, 5.0), center.add(5.0, 6.0, 5.0)), e -> {
            if (!e.getType().is(ETags.EntityTypes.MONSTERS)) return false;
            Vec3 vec3 = new Vec3(e.getX() - center.x, 0.0, e.getZ() - center.z);
            if (!(vec3.lengthSqr() < 9.0)) return false;
            return true;
        });
        for (Entity entity : entities) {
            Entity toApply = EntityUtils.getControllingEntity(entity);
            Vec3 local = new Vec3(toApply.getX() - center.x, 0.0, toApply.getZ() - center.z);
            Vec3 vel = toApply.getDeltaMovement();
            vel = new Vec3(vel.x, 0.0, vel.z);
            double dot = vel.dot(local) / local.dot(local);
            if (dot > 0.0) {
                toApply.addDeltaMovement(local.scale(dot));
            }
            double d = local.length();
            toApply.addDeltaMovement(local.scale((1.0 - d / 3.0) * 3.0 / d));
        }
        if (params.ticks() % 2 == 0) {
            double cx = (double)this.pos.getX() + 0.5;
            double cz = (double)this.pos.getZ() + 0.5;
            double dy = (double)this.pos.getY() + 0.1;
            double dz = (double)this.pos.getZ() + 0.5;
            this.level.sendParticles((ParticleOptions)new ColouredCircleOptions(EParticleTypes.CIRCLE_MAGIC.get(), -1, new Vec3(cx, (double)this.pos.getY(), cz), 3.0f), cx + 3.0, dy, dz, 1, 0.0, 0.35, 0.0, 0.0);
            this.level.sendParticles((ParticleOptions)new ColouredCircleOptions(EParticleTypes.CIRCLE_MAGIC.get(), -1, new Vec3(cx, (double)this.pos.getY(), cz), 3.0f), cx - 3.0, dy, dz, 1, 0.0, 0.35, 0.0, 0.0);
        }
        return true;
    }
}

