/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.favouriteless.enchanted.common.blocks.entity.GoldChalkBlockEntity;
import net.favouriteless.enchanted.common.circle_magic.RiteManager;
import net.favouriteless.enchanted.common.circle_magic.RiteType;
import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.common.items.component.EDataComponents;
import net.favouriteless.enchanted.common.items.component.EntityRefData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public abstract class Rite {
    protected final RiteType type;
    protected final ServerLevel level;
    protected final BlockPos pos;
    protected final int tickPower;
    private RiteParams params;
    private final Map<UUID, WeakReference<Entity>> entityCache = new HashMap<UUID, WeakReference<Entity>>();

    protected Rite(BaseRiteParams baseParams, RiteParams params) {
        this.type = baseParams.type;
        this.level = baseParams.level;
        this.pos = baseParams.pos;
        this.tickPower = baseParams.tickPower;
        this.params = params;
    }

    protected boolean onStart(RiteParams params) {
        return true;
    }

    protected boolean onTick(RiteParams params) {
        return false;
    }

    protected void onStop(RiteParams params) {
    }

    protected void saveAdditional(CompoundTag tag, ServerLevel level) {
    }

    protected void loadAdditional(CompoundTag tag, ServerLevel level) {
    }

    protected boolean cancel() {
        this.level.playSound(null, this.pos, (SoundEvent)SoundEvents.NOTE_BLOCK_SNARE.value(), SoundSource.MASTER, 1.0f, 1.0f);
        for (ItemStack stack : this.params.consumedItems) {
            ItemEntity entity = new ItemEntity((Level)this.level, (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5, stack);
            this.level.addFreshEntity((Entity)entity);
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
        if (blockEntity instanceof GoldChalkBlockEntity) {
            GoldChalkBlockEntity chalk = (GoldChalkBlockEntity)blockEntity;
            chalk.detatch();
        }
        return false;
    }

    protected void consumeItem(ItemEntity entity) {
        if (!entity.getItem().is(EItems.ATTUNED_STONE_CHARGED.get())) {
            this.params.consumedItems.add(entity.getItem());
            entity.discard();
        } else {
            entity.setItem(new ItemStack((ItemLike)EItems.ATTUNED_STONE.get(), entity.getItem().getCount()));
        }
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.CHICKEN_EGG, SoundSource.MASTER, 1.0f, 1.0f);
        ((ServerLevel)entity.level()).sendParticles((ParticleOptions)ParticleTypes.CLOUD, entity.getX(), entity.getY(), entity.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
    }

    @Nullable
    protected Entity findEntity(UUID uuid) {
        ServerPlayer out;
        if (this.entityCache.containsKey(uuid)) {
            out = (Entity)this.entityCache.get(uuid).get();
            if (out != null) {
                return out;
            }
            this.entityCache.remove(uuid);
        }
        if ((out = this.level.getServer().getPlayerList().getPlayer(uuid)) != null) {
            return this.cacheAndReturn(uuid, (Entity)out);
        }
        for (ServerLevel dim : this.level.getServer().getAllLevels()) {
            out = dim.getEntity(uuid);
            if (out == null) continue;
            return this.cacheAndReturn(uuid, (Entity)out);
        }
        return null;
    }

    protected UUID findTargetUUID(ServerLevel level, BlockPos pos, RiteParams params) {
        for (ItemStack stack : params.consumedItems) {
            if (!stack.has(EDataComponents.ENTITY_REF.get())) continue;
            return ((EntityRefData)stack.get(EDataComponents.ENTITY_REF.get())).uuid();
        }
        return null;
    }

    protected void randomParticles(ParticleOptions options) {
        this.level.sendParticles(options, (double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ(), 25, 1.5, 1.5, 1.5, 0.0);
    }

    public boolean tick() {
        if (this.level.isLoaded(this.pos)) {
            GoldChalkBlockEntity chalk;
            BlockEntity blockEntity;
            if (!(this.tickPower <= 0 || (blockEntity = this.level.getBlockEntity(this.pos)) instanceof GoldChalkBlockEntity && (chalk = (GoldChalkBlockEntity)blockEntity).tryConsumePower(this.tickPower))) {
                return this.stop();
            }
            if (!this.onTick(this.params)) {
                return this.stop();
            }
        }
        ++this.params.ticks;
        return true;
    }

    public void start() {
        this.params.target = this.findTargetUUID(this.level, this.pos, this.params);
        if (!this.onStart(this.params)) {
            this.stop();
            RiteManager.removeRite(this.level, this);
        }
    }

    public boolean stop() {
        this.onStop(this.params);
        BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
        if (blockEntity instanceof GoldChalkBlockEntity) {
            GoldChalkBlockEntity chalk = (GoldChalkBlockEntity)blockEntity;
            chalk.detatch();
        }
        return false;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.put("Params", (Tag)RiteParams.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)this.level.registryAccess()), (Object)this.params).getOrThrow());
        this.saveAdditional(tag, this.level);
        return tag;
    }

    public void load(CompoundTag tag) {
        this.params = (RiteParams)RiteParams.CODEC.parse((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)this.level.registryAccess()), (Object)tag.get("Params")).getOrThrow();
        this.loadAdditional(tag, this.level);
    }

    public RiteType getType() {
        return this.type;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    private Entity cacheAndReturn(UUID uuid, Entity entity) {
        this.entityCache.put(uuid, new WeakReference<Entity>(entity));
        return entity;
    }

    public record BaseRiteParams(RiteType type, ServerLevel level, BlockPos pos, int tickPower) {
    }

    public static class RiteParams {
        public static final Codec<RiteParams> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("caster").forGetter(p -> p.caster), (App)UUIDUtil.CODEC.optionalFieldOf("target").forGetter(p -> Optional.ofNullable(p.target)), (App)ItemStack.CODEC.listOf().fieldOf("consumed_items").forGetter(p -> p.consumedItems), (App)Codec.INT.fieldOf("ticks").forGetter(p -> p.ticks)).apply((Applicative)instance, (caster, target, consumedItems, ticks) -> new RiteParams((UUID)caster, target.orElse(null), (List<ItemStack>)consumedItems, (int)ticks)));
        public final List<ItemStack> consumedItems;
        public final UUID caster;
        @Nullable
        public UUID target;
        private int ticks;

        private RiteParams(UUID caster, UUID target, List<ItemStack> consumedItems, int ticks) {
            this.caster = caster;
            this.target = target;
            this.consumedItems = new ArrayList<ItemStack>(consumedItems);
            this.ticks = ticks;
        }

        public static RiteParams of(UUID caster, List<ItemStack> consumedItems) {
            return new RiteParams(caster, null, consumedItems, 0);
        }

        public static RiteParams empty() {
            return new RiteParams(null, null, List.of(), 0);
        }

        public int ticks() {
            return this.ticks;
        }
    }
}

