/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import java.util.List;
import net.favouriteless.enchanted.api.curses.Curse;
import net.favouriteless.enchanted.api.curses.CurseManager;
import net.favouriteless.enchanted.api.familiars.FamiliarSavedData;
import net.favouriteless.enchanted.api.familiars.IFamiliarEntry;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.curses.CurseSavedData;
import net.favouriteless.enchanted.common.curses.CurseType;
import net.favouriteless.enchanted.common.familiars.FamiliarTypes;
import net.favouriteless.enchanted.common.init.EParticleTypes;
import net.favouriteless.enchanted.common.init.ESoundEvents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;

public class RemoveCurseRite
extends Rite {
    public static final int RAISE = 300;
    public static final int START_SOUND = 190;
    private final CurseType<?> curse;

    public RemoveCurseRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params, CurseType<?> curse) {
        super(baseParams, params);
        this.curse = curse;
    }

    @Override
    protected boolean onStart(Rite.RiteParams params) {
        if (params.target == null) {
            return this.cancel();
        }
        this.level.sendParticles((ParticleOptions)EParticleTypes.REMOVE_CURSE_SEED.get(), (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 2.5, (double)this.pos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        return true;
    }

    @Override
    protected boolean onTick(Rite.RiteParams params) {
        if (params.ticks() == 190) {
            this.level.playSound(null, this.pos, (SoundEvent)ESoundEvents.REMOVE_CURSE.value(), SoundSource.MASTER, 1.0f, 1.0f);
            return true;
        }
        if (params.ticks() == 300) {
            IFamiliarEntry familiar = FamiliarSavedData.get((Level)this.level).getEntry(params.caster);
            int strength = 0;
            if (familiar != null && familiar.getType() == FamiliarTypes.CAT) {
                ++strength;
            }
            CurseSavedData data = CurseSavedData.get(this.level);
            List<Curse> curses = data.get(params.target);
            for (Curse curse : curses) {
                if (curse.type != this.curse) continue;
                double chance = (double)(strength - curse.strength) * 0.2;
                if (Math.random() > chance) {
                    CurseManager.get().removeCurse(this.level, curse);
                    break;
                }
                if (curse.strength >= 2) break;
                ++curse.strength;
                data.setDirty();
                break;
            }
            return false;
        }
        return true;
    }
}

