/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import java.util.function.Function;
import net.favouriteless.enchanted.client.particles.types.DoubleOptions;
import net.favouriteless.enchanted.common.circle_magic.rites.LocationTargetRite;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.init.EBlocks;
import net.favouriteless.enchanted.common.init.EParticleTypes;
import net.favouriteless.enchanted.common.stateobservers.ProtectionRiteObserver;
import net.favouriteless.enchanted.common.util.BlockPosUtils;
import net.favouriteless.stateobserver.api.StateObserver;
import net.favouriteless.stateobserver.api.StateObserverManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrierBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;

public class ProtectionRite
extends LocationTargetRite {
    private final int radius;
    private final int duration;
    private final boolean blocksPlayers;
    protected ProtectionRiteObserver observer = null;

    public ProtectionRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params, int radius, int duration, boolean blocking) {
        super(baseParams, params);
        this.radius = radius;
        this.duration = duration;
        this.blocksPlayers = blocking;
    }

    @Override
    protected boolean onStart(Rite.RiteParams params) {
        super.onStart(params);
        Block block = this.blocksPlayers ? (Block)EBlocks.PROTECTION_BARRIER_BLOCKING.get() : (Block)EBlocks.PROTECTION_BARRIER.get();
        this.generateSphere(this.targetLevel, this.targetPos, state -> {
            if (!state.getFluidState().isEmpty()) {
                return state.getFluidState().getType() == Fluids.WATER ? (BlockState)block.defaultBlockState().setValue((Property)BarrierBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)) : block.defaultBlockState();
            }
            if (state.isAir()) {
                return block.defaultBlockState();
            }
            return null;
        });
        this.getOrCreateObserver(this.targetLevel, this.targetPos);
        this.targetLevel.playSound(null, this.targetPos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.MASTER, 1.0f, 1.0f);
        return true;
    }

    @Override
    protected boolean onTick(Rite.RiteParams params) {
        this.observer.checkChanges();
        if (params.ticks() % 20 == 0) {
            this.targetLevel.sendParticles((ParticleOptions)new DoubleOptions(EParticleTypes.PROTECTION_SEED.get(), this.radius), (double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY() + 0.6, (double)this.targetPos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        return params.ticks() < this.duration;
    }

    @Override
    protected void onStop(Rite.RiteParams params) {
        this.targetLevel.playSound(null, this.targetPos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.MASTER, 1.0f, 0.5f);
        StateObserverManager.get().removeObserver((StateObserver)this.observer);
        this.generateSphere(this.targetLevel, this.targetPos, state -> {
            if (state.is((Block)EBlocks.PROTECTION_BARRIER.get()) || state.is((Block)EBlocks.PROTECTION_BARRIER_BLOCKING.get())) {
                return (Boolean)state.getValue((Property)BarrierBlock.WATERLOGGED) != false ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            }
            return null;
        });
    }

    @Override
    protected void loadAdditional(CompoundTag tag, ServerLevel level) {
        super.loadAdditional(tag, level);
        this.getOrCreateObserver(this.targetLevel, this.targetPos);
    }

    protected void generateSphere(ServerLevel level, BlockPos pos, Function<BlockState, BlockState> stateGetter) {
        BlockPosUtils.iterableSphereHollow(pos, this.radius).forEach(spherePos -> {
            BlockState state = (BlockState)stateGetter.apply(level.getBlockState((BlockPos)spherePos));
            if (state != null) {
                level.setBlockAndUpdate((BlockPos)spherePos, state);
            }
        });
    }

    protected void getOrCreateObserver(ServerLevel level, BlockPos pos) {
        if (this.observer == null) {
            this.observer = (ProtectionRiteObserver)StateObserverManager.get().getObserver((Level)level, pos, ProtectionRiteObserver.class);
        }
        if (this.observer == null) {
            this.observer = (ProtectionRiteObserver)StateObserverManager.get().addObserver((StateObserver)new ProtectionRiteObserver((Level)level, pos, this.radius + 1, this.radius + 1, this.radius + 1, this.blocksPlayers ? (BarrierBlock)EBlocks.PROTECTION_BARRIER_BLOCKING.get() : (BarrierBlock)EBlocks.PROTECTION_BARRIER.get(), this.radius));
        }
    }
}

