/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import com.mojang.serialization.DynamicOps;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;

public abstract class LocationTargetRite
extends Rite {
    protected ServerLevel targetLevel = null;
    protected BlockPos targetPos = null;

    protected LocationTargetRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params) {
        super(baseParams, params);
    }

    @Override
    protected boolean onStart(Rite.RiteParams params) {
        this.findTargetLocation(params);
        if (this.targetLevel == null || this.targetPos == null) {
            this.cancel();
        }
        return false;
    }

    protected void findTargetLocation(Rite.RiteParams params) {
        this.targetLevel = this.level;
        this.targetPos = this.pos;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, ServerLevel level) {
        if (this.targetPos != null) {
            tag.put("targetPos", (Tag)BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.targetPos).getOrThrow());
        }
        if (this.targetLevel != null) {
            tag.putString("targetLevel", this.targetLevel.dimension().location().toString());
        }
    }

    @Override
    protected void loadAdditional(CompoundTag tag, ServerLevel level) {
        if (tag.contains("targetPos")) {
            this.targetPos = (BlockPos)BlockPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("targetPos")).getOrThrow();
        }
        if (tag.contains("targetLevel")) {
            this.targetLevel = level.getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)tag.getString("targetLevel"))));
        }
    }
}

