/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import java.util.List;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.init.EParticleTypes;
import net.favouriteless.enchanted.common.init.ETags;
import net.favouriteless.enchanted.common.util.EntityUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ImprisonmentRite
extends Rite {
    public static final double ATTRACT_FACTOR = 0.6;
    public static final double INNER_RADIUS = 3.0;
    public static final double OUTER_RADIUS = 4.0;
    private static final double INNER_RADIUS_SQR = 9.0;
    private static final double OUTER_RADIUS_SQR = 16.0;

    public ImprisonmentRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params) {
        super(baseParams, params);
    }

    @Override
    protected boolean onStart(Rite.RiteParams params) {
        this.level.playSound(null, this.pos, SoundEvents.ZOMBIE_VILLAGER_CURE, SoundSource.MASTER, 0.5f, 1.0f);
        return true;
    }

    @Override
    protected boolean onTick(Rite.RiteParams params) {
        Vec3 center = this.pos.getBottomCenter();
        List entities = this.level.getEntities((Entity)null, new AABB(center.subtract(4.0, 0.0, 4.0), center.add(4.0, 4.0, 4.0)), e -> {
            if (!e.getType().is(ETags.EntityTypes.MONSTERS)) return false;
            Vec3 vec3 = new Vec3(e.getX() - center.x, 0.0, e.getZ() - center.z);
            if (!(vec3.lengthSqr() > 9.0)) return false;
            Vec3 vec32 = new Vec3(e.getX() - center.x, 0.0, e.getZ() - center.z);
            if (!(vec32.lengthSqr() < 16.0)) return false;
            return true;
        });
        for (Entity entity : entities) {
            double d;
            Entity toApply = EntityUtils.getControllingEntity(entity);
            Vec3 local = new Vec3(toApply.getX() - center.x, 0.0, toApply.getZ() - center.z);
            Vec3 vel = toApply.getDeltaMovement();
            vel = new Vec3(vel.x, 0.0, vel.z);
            double dot = vel.dot(local) / local.dot(local);
            if (dot > 0.0) {
                toApply.addDeltaMovement(local.scale(-dot));
            }
            if (!((d = local.lengthSqr()) > 7.289999935626984)) continue;
            toApply.addDeltaMovement(local.scale(-0.6 / d));
        }
        if (params.ticks() % 55 == 0) {
            this.level.sendParticles((ParticleOptions)EParticleTypes.IMPRISONMENT_CAGE_SEED.get(), (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.2, (double)this.pos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        return true;
    }
}

