/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.init.EParticleTypes;
import net.favouriteless.enchanted.common.util.BlockPosUtils;
import net.favouriteless.enchanted.mixin.common.SaplingBlockAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class ForestRite
extends Rite {
    private final int spacing;
    private final int maxSteps;
    private SaplingBlock sapling;
    private int step = 0;
    private final List<BlockPos> usedPositions = new ArrayList<BlockPos>();

    public ForestRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params, int radius, int spacing) {
        super(baseParams, params);
        this.spacing = spacing;
        this.maxSteps = radius / spacing;
    }

    @Override
    protected boolean onStart(Rite.RiteParams params) {
        this.sapling = this.getSapling();
        if (this.sapling == null) {
            return this.cancel();
        }
        this.level.playSound(null, this.pos, SoundEvents.ZOMBIE_VILLAGER_CURE, SoundSource.MASTER, 0.5f, 1.0f);
        return true;
    }

    @Override
    protected boolean onTick(Rite.RiteParams params) {
        if (params.ticks() % 20 != 0) {
            return true;
        }
        BlockState state = this.sapling.defaultBlockState();
        double r = (double)this.spacing / 1.7;
        double o = r / 2.0;
        BlockPosUtils.iterableCircleHollow(this.pos, this.step * this.spacing, this.spacing).forEach(circlePos -> {
            if (Math.random() < 0.3) {
                return;
            }
            circlePos.move((int)Math.round(Math.random() * r - o), 0, (int)Math.round(Math.random() * r - o));
            BlockPos tree = this.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)circlePos);
            if (!this.level.getBlockState(tree).canBeReplaced() || !state.canSurvive((LevelReader)this.level, tree)) {
                return;
            }
            if (((SaplingBlockAccessor)this.sapling).getTreeGrower().growTree(this.level, this.level.getChunkSource().getGenerator(), tree, state, this.level.random)) {
                this.level.playSound(null, this.pos, SoundEvents.FUNGUS_PLACE, SoundSource.MASTER, 3.0f, 1.0f);
                this.usedPositions.add(tree);
            }
        });
        this.level.sendParticles((ParticleOptions)EParticleTypes.FERTILITY_SEED.get(), (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        return this.step++ < this.maxSteps;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, ServerLevel level) {
        tag.putInt("step", this.step);
        tag.putString("sapling", BuiltInRegistries.BLOCK.getKey((Object)this.sapling).toString());
        tag.put("used", (Tag)BlockPos.CODEC.listOf().encodeStart((DynamicOps)NbtOps.INSTANCE, this.usedPositions).getOrThrow());
    }

    @Override
    protected void loadAdditional(CompoundTag tag, ServerLevel level) {
        this.step = tag.getInt("step");
        this.sapling = (SaplingBlock)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)tag.getString("sapling")));
        this.usedPositions.addAll((Collection)BlockPos.CODEC.listOf().parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("used")).getOrThrow());
    }

    protected SaplingBlock getSapling() {
        List entities = this.level.getEntitiesOfClass(ItemEntity.class, this.type.getBounds(this.pos));
        for (ItemEntity entity : entities) {
            BlockItem blockItem;
            Item item = entity.getItem().getItem();
            if (!(item instanceof BlockItem) || !((item = (blockItem = (BlockItem)item).getBlock()) instanceof SaplingBlock)) continue;
            SaplingBlock sapling = (SaplingBlock)item;
            this.consumeItem(entity);
            return sapling;
        }
        return null;
    }
}

