/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import java.util.ArrayList;
import java.util.UUID;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.init.EParticleTypes;
import net.favouriteless.enchanted.common.init.ETags;
import net.favouriteless.enchanted.common.util.BlockPosUtils;
import net.favouriteless.enchanted.mixin.common.ZombieVillagerAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;

public class FertilityRite
extends Rite {
    public static final int TICKS_PER_BLOCK = 5;
    protected final int radius;
    protected final int radiusSq;
    protected final double bonemealChance;
    protected int step = 1;

    public FertilityRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params, int radius, double bonemealChance) {
        super(baseParams, params);
        this.radius = radius;
        this.radiusSq = radius * radius;
        this.bonemealChance = bonemealChance;
    }

    @Override
    protected boolean onStart(Rite.RiteParams params) {
        UUID caster = params.caster;
        this.level.getEntitiesOfClass(LivingEntity.class, this.type.getBounds(this.pos), e -> e.position().distanceToSqr(this.pos.getCenter()) < (double)this.radiusSq).forEach(entity -> this.applyCureEffects(caster, (LivingEntity)entity));
        return true;
    }

    @Override
    protected boolean onTick(Rite.RiteParams params) {
        if (params.ticks() % 5 != 0) {
            return true;
        }
        BlockPosUtils.iterableSphereHollow(this.pos, this.step).forEach(spherePos -> {
            if (Math.random() > this.bonemealChance) {
                return;
            }
            BlockState state = this.level.getBlockState((BlockPos)spherePos);
            if (state.isAir()) {
                return;
            }
            Block patt0$temp = state.getBlock();
            if (patt0$temp instanceof BonemealableBlock) {
                BonemealableBlock block = (BonemealableBlock)patt0$temp;
                block.performBonemeal(this.level, this.level.random, (BlockPos)spherePos, state);
            }
        });
        if (params.ticks() % 25 == 0) {
            this.level.playSound(null, this.pos, SoundEvents.ENDER_DRAGON_GROWL, SoundSource.MASTER, 0.1f, 1.0f);
            this.level.sendParticles((ParticleOptions)EParticleTypes.FERTILITY_SEED.get(), (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        return this.step++ < this.radius;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, ServerLevel level) {
        tag.putInt("step", this.step);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, ServerLevel level) {
        this.step = tag.getInt("step");
    }

    protected void applyCureEffects(UUID casterUUID, LivingEntity target) {
        if (target instanceof ZombieVillager) {
            ZombieVillager villager = (ZombieVillager)target;
            ((ZombieVillagerAccessor)villager).invokeStartConverting(casterUUID, Enchanted.RANDOM.nextInt(2401) + 3600);
            return;
        }
        ArrayList<Holder> toRemove = new ArrayList<Holder>();
        for (Holder effect : target.getActiveEffectsMap().keySet()) {
            if (!effect.is(ETags.MobEffects.FERTILITY_CURE_EFFECTS)) continue;
            toRemove.add(effect);
        }
        toRemove.forEach(arg_0 -> ((LivingEntity)target).removeEffect(arg_0));
    }
}

