/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import java.util.List;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.items.component.EDataComponents;
import net.favouriteless.enchanted.common.items.component.EntityRefData;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class EntityBoundCreateItemRite
extends Rite {
    private final List<ItemStack> items;

    public EntityBoundCreateItemRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params, List<ItemStack> items) {
        super(baseParams, params);
        this.items = items;
    }

    @Override
    protected boolean onStart(Rite.RiteParams params) {
        EntityRefData ref = null;
        for (ItemStack stack : params.consumedItems) {
            if (!stack.has(EDataComponents.ENTITY_REF.get())) continue;
            ref = (EntityRefData)stack.get(EDataComponents.ENTITY_REF.get());
            Entity entity = this.findEntity(ref.uuid());
            if (entity == null) break;
            ref = EntityRefData.of(ref.uuid(), entity.getDisplayName().getString());
            break;
        }
        for (ItemStack stack : this.items) {
            stack.set(EDataComponents.ENTITY_REF.get(), (Object)ref);
            ItemEntity itemEntity = new ItemEntity((Level)this.level, (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5, stack.copy());
            this.level.addFreshEntity((Entity)itemEntity);
        }
        this.level.playSound(null, this.pos, SoundEvents.ZOMBIE_VILLAGER_CURE, SoundSource.MASTER, 0.5f, 1.0f);
        this.randomParticles((ParticleOptions)ParticleTypes.WITCH);
        return false;
    }
}

