/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DuplicateItemRite
extends Rite {
    private final Item targetItem;
    private final int count;

    public DuplicateItemRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params, Item targetItem, int count) {
        super(baseParams, params);
        this.targetItem = targetItem;
        this.count = count;
    }

    @Override
    protected boolean onStart(Rite.RiteParams params) {
        for (ItemStack stack : params.consumedItems) {
            if (stack.getItem() != this.targetItem) continue;
            ItemStack copy = stack.copy();
            copy.setCount(this.count);
            ItemEntity itemEntity = new ItemEntity((Level)this.level, (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5, copy);
            this.level.addFreshEntity((Entity)itemEntity);
            break;
        }
        this.level.playSound(null, this.pos, SoundEvents.ZOMBIE_VILLAGER_CURE, SoundSource.MASTER, 0.5f, 1.0f);
        this.randomParticles((ParticleOptions)ParticleTypes.WITCH);
        return false;
    }
}

